/* Extended CONIO.H stubs, C source.
 * (C)2021 - Andy Stamp
 *
 * Implements
 * Turbo C conio extensions using BIOS calls.
 */
#include "hh_conio.h"
#include <dos.h>
#include <string.h>

int __CON_FUNC
wherex (void)
{
  union REGS regs;
  memset(&regs, 0, sizeof(regs));
  regs.h.ah = 0x03;
  regs.h.bh = 0;
  int86 (0x10, &regs, &regs);
  return regs.h.dl;
}

int __CON_FUNC
wherey (void)
{
  union REGS regs;
  memset(&regs, 0, sizeof(regs));
  regs.h.ah = 0x03;
  regs.h.bh = 0;
  int86 (0x10, &regs, &regs);
  return regs.h.dh;
}

void __CON_FUNC
gotoxy (int x, int y)
{
  union REGS regs;
  memset(&regs, 0, sizeof(regs));
  regs.h.ah = 0x02;
  regs.h.bh = 0;
  regs.h.dh = y;
  regs.h.dl = x;
  int86 (0x10, &regs, &regs);
}

void __CON_FUNC
_setcursortype (int type)
{
  unsigned short value;
  union REGS regs;
  memset(&regs, 0, sizeof(regs));

  switch (type)
    {
    case _NOCURSOR:
      value = 0x2607;
      break;
    case _SOLIDCURSOR:
      value = 0x000F;
      break;
    case _NORMALCURSOR:
    default:
      value = 0x0607;
      break;
    }

  regs.h.ah = 0x01;
  regs.h.bh = 0;
  regs.x.cx = value;
  int86 (0x10, &regs, &regs);
}
