program MenuStav;
{$include DEFINES.INC}
uses Vaznik,VenomGFX,Wokna32,Vnm_FN,Woknadef,Nadwokna,Fnfont3,Lacrt,Rezklav;

const PRIDAVAC_STR = '+++++++++';
      PRIDAVAC  = -999991;
      SYST_MENU = -999993;
      KONEC_PROGRAMU = -1;
      POCET_MEZER    =  3;

type

PMojeTextovePole = ^TMojeTextovePole;
TMojeTextovePole=object(TTextovePole)
   Constructor Init(ix,iy:integer;idelka:longint;itext:string;iakt:boolean;ivyznam:longint);
   Procedure Kontrola;
   end;

var klavesa:word;
    def:PStrom;
    pasexp:text;            {pouzije se pro export do pascalovskeho zdrojaku}
    bylo_pridano:boolean;
    odsazeni:longint;
    pocet_podvetvi:longint;
    novy_strom:PStrom;      {pouzije se pri nacteni noveho stromu}
                            {behem nacitani jsme totiz jeste zalezli v polozkach stareho stromu}

Function Zeptej_se_na_udaje(q:PStrom;id:longint;nova:boolean):pointer;forward;


Constructor TMojeTextovePole.Init(ix,iy:integer;idelka:longint;itext:string;iakt:boolean;ivyznam:longint);
begin
inherited init(ix,iy,idelka,itext,iakt,ivyznam);
end;


Procedure TMojeTextovePole.Kontrola;
var i,j:longint;
begin
inherited Kontrola;
if stav in [_aktivni,_neaktivni] then Exit;
Val(hodnota^.p,i,j);
if (j<>0) or (i<=0) then
   begin
   VlozHodnotu(default);Zobraz;stav:=_neaktivni;
   end;
end;

Procedure Init;
begin
FontAdr('.\fonty\');              {Adresar s fonty}
Init_Graph(Find_Mode(800,600),ANY_ACCESS,BEST_FQ or 70);
Init_Mouse(vga);
clr(vga,MyRGB2word(0,80,90));
MouseShow;
end;

Procedure UklidProgram;
begin
MouseHide;
Kill_Mouse;
Kill_Graph;
end;

Procedure Napoveda;
var p:pchar;
    a:ansistring;
begin
p:=ansistring('<FONT=surea37.fn>Menustav<SF>'#13#10+
   'verze 1.5'#13#10+
   'v obdob 2014-2022 naprogramoval Laaca (laaca@seznam.cz)'#13#10#13#10+
   'Menustav je soust balku Wokna32.'#13#10+
   'Pomoc tohoto programu me vizuln navrhovat stromov menu.'#13#10+
   'Vsledn menu je na disku uloeno v binrnm kompaktnm tvaru.'#13#10+
   'Na disk se neukldaj tlatka pro pidvn'#13#10+
   'poloek a poloka "<<systmov menu>>"'#13#10+
   'Rovnا nen definovno, m-li menu vodorovn nebo svisl zklad.'#13#10+
   'Buto me pout export do zpisu v pascalu anebo je mon'#13#10+
   'natat binrn formt menu.'#13#10+
   'Kdy se rozhodne pro textov tvar, tak jednodue vlo'#13#10+
   'vygenerovan soubor do svho zdrojku.'#13#10+
   'Jestli chce pout binrn formu,'#13#10+
   'pouij pro naten funkci <BARVA=65346>NactiVybernicek<SB>'#13#10+
   'Kompletn zdrojk pouit menu by pak vypadal teba takto:<FONT=couri18.fn>'#13#10#13#10+
   '<BARVA=65508>var<SB> f:PVybernicek;'#13#10+
   '    p,q:PStrom;'#13#10+
   '    x,y,moznosti:longint;'#13#10+
   '<BARVA=65508>begin<SB>'#13#10+
   'p:=<BARVA=65508>New<SB>(PStrom,Init(<BARVA=65508>nil<SB>,<BARVA=65508>nil<SB>,<BARVA=65508>nil<SB>));'#13#10+
   'NactiVybernicek(p,''soubor.dat'');'#13#10+
   'x:=0;y:=50;'#13#10+
   'moznosti:=vbVEDLESEBE;'#13#10+
   'f:=<BARVA=65508>New<SB>(PVybernicek,Init(x,y,moznosti,p));'#13#10+
   'q:=f^.Vyber;<SF>');
OKokno('Npovda',p);
end;

Function ZrusPolozku(p:PStrom;jen_potomky:boolean):longint;
begin
if p^.num_childerns>1 then if not AnoNeOkno('Tato poloka m potomky!'+#13#10+'Jse si jist?') then Exit(0);
OdstranPolozky(p^.potomek);
if jen_potomky=false then
   begin
   Dispose(p^.dejdalsi,Done);
   Dispose(p,Done);
   end;
def:=nil;
ZrusPolozku:=-1;
end;

Function ZmenaUdaju(s:PStrom):longint;
var gb:PVybernicek;
    lm,q:PStrom;
    v,v2:PPolozka;
    x,y,i,j:longint;
begin
v:=s^.vazba;
x:=(v^.x2+v^.x1) div 2;
y:=(v^.y2+v^.y1) div 2;
if x>vga.breite div 2 then x:=vga.breite div 2;
if y>vga.hoehe div 2 then y:=vga.hoehe div 2;

lm:=StromDef(UzelS(VytvorPolozku('ID poloky: '+MyStr(v^.id),'zmna ID nebo jinch daj poloky',1,true),
             UzelS(VytvorPolozku('zmna daj poloky','zmna ID nebo jinch daj poloky',1,true),
             UzelS(VytvorPolozku('zruit poloku','zru poloku vetn vech jejch potomk',2,true),nil
             )))
            );

if s^.potomek<>nil then lm^.potomek^.InitNext(VytvorPolozku('odstra podnabdku','zru vechny podzen poloky',3,true));


gb:=New(PVybernicek,Init(x,y,0,lm));
q:=gb^.Vyber;
if q=nil then begin OdstranPolozky(lm);Exit(0);end;
j:=1;
i:=VybraneID(q);
if i=1 then
   begin
   v2:=Zeptej_se_na_udaje(s,v^.id,false);
   s^.vazba:=v2;
   Dispose(v);
   end else
if i=2 then j:=ZrusPolozku(s,false) else j:=ZrusPolozku(s,true);


ZmenaUdaju:=j;
OdstranPolozky(lm);
Dispose(gb,Done);
end;

Function PridejNovouPolozku(s:PStrom):longint;
var s2:PStrom;
    p:PPolozka;
begin
p:=Zeptej_se_na_udaje(s,1,true);
if p<>nil then
   begin
   s2:=New(PStrom,Init(s^.rodic,nil,nil));
   s2^.vazba:=p;
   s^.Insert(s2);
   p:=VytvorPolozku(PRIDAVAC_STR,'Kliknutm na toto tlatko vytvo novou poloku',PRIDAVAC,true);
   s2:=New(PStrom,Init(s^.rodic,nil,nil));
   s2^.vazba:=p;
   s^.dalsi^.Insert(s2);
   def:=s2^.dejpredchozi;
   bylo_pridano:=true;
   Exit(1);
   end;
PridejNovouPolozku:=0;
end;

Procedure ProrezStrom(q:PStrom);
var p,r:PStrom;
    v:PPolozka;
begin
if q^.potomek=nil then Exit;
p:=q^.potomek^.dejdalsi;
while p<>nil do
   begin
   v:=p^.vazba;
   r:=p^.dejdalsi;
   if v<>nil then
      begin
      if (v^.id=PRIDAVAC) or (v^.id=SYST_MENU) then
         begin
         Dispose(v);
         Dispose(p,Done);
         end;
      end;
   p:=r;
   end;
if q^.potomek^.dejdalsi=nil then
   begin
   Dispose(q^.potomek,Done);
   q^.potomek:=nil;           {mel by to zajistit uz konstruktor Done, ale pro jistotu...}
   end
   else begin
   p:=q^.potomek^.dejdalsi;
   while p<>nil do
      begin
      ProrezStrom(p);
      p:=p^.dejdalsi;
      end;
   end;
end;

Procedure _RozvetviStrom(q:PStrom);
var p,r,h:PStrom;
begin
if q^.potomek=nil then Exit;
p:=q^.potomek;
while p<>nil do
   begin
   h:=p^.dejdalsi;
   r:=New(PStrom,Init(p^.rodic,nil,nil));
   p^.Insert(r);
   r^.vazba:=VytvorPolozku(PRIDAVAC_STR,'',PRIDAVAC,true);
   p:=h;
   end;
p:=q^.potomek;
while p<>nil do
   begin
   _RozvetviStrom(p);
   p:=p^.dejdalsi;
   end;
end;

Procedure RozvetviStrom(q:PStrom);
var r:PStrom;
begin
if q^.potomek=nil then              {stane se to predtim, pri prorezani prazdneho stromu}
   begin                            {v tom pripade musim zalozit prazdneho potomka,}
   r:=New(PStrom,Init(q,nil,nil));  {abych nematl proceduru _RozvetviStrom}
   q^.potomek:=r;
   end;

_RozvetviStrom(q);
r:=New(PStrom,Init(q,nil,nil));
r^.vazba:=VytvorPolozku('<BARVA=150><<Systmov menu>><SB>','',SYST_MENU,true);
q^.potomek^.Insert(r);
end;

Function UlozMenu(q:PStrom):longint;
var s:string;
begin
def:=nil;
ProrezStrom(q);
s:=UlozSouborOkno('Jak to mm uloit?','',400,true);
if s<>'' then UlozVybernicek(q,s);
RozvetviStrom(q);
UlozMenu:=-1;
end;

Function NahrajMenu:longint;
var s:string;
    i:longint;
begin
s:=VyberSouborOkno('Jak soubor mm nast','*.*','dat',350,VSNORMAL);
if s='' then Exit(0);

{s:='mojemenu.dat';}
Novy_strom:=NovyStrom;
i:=NactiVybernicek(Novy_strom,s);
if i=st_OK then
   begin
   NahrajMenu:=-2;
   RozvetviStrom(Novy_Strom);
   end
   else begin
   Dispose(Novy_strom,Done);  {nakonec teda potreba nebude...}
   if i=st_FILENOTEXIST then OKokno('Chyba!','Takov soubor'#13#10'neexistuje!')
       {st_BADFORMAT}   else OKokno('Chyba!','Tento soubor nen'#13#10've sprvnm formtu!');
   NahrajMenu:=-1;
   end;
def:=nil;
end;

Function VytvorNovyStrom(s:Pstrom):longint;
var r:PStrom;
begin
if s^.potomek^.dejdalsi^.dejdalsi^.dejdalsi<>nil then
   if not AnoNeOkno('Strom nabdek nen przdn!'#13#10'Jse si jist?') then Exit(-1);
Novy_strom:=NovyStrom;
r:=New(PStrom,Init(Novy_strom,nil,nil));
Novy_Strom^.potomek:=r;
RozvetviStrom(Novy_Strom);
VytvorNovyStrom:=-2;
end;

Procedure ExportujPolozku(p:PStrom);
var v:PPolozka;
    i,j:longint;
begin
write(pasexp,#13#10);
if p^.potomek=nil then
   begin
   v:=p^.vazba;
   write(pasexp,Xmezer(odsazeni));
   write(pasexp,'UzelS(VytvorPolozku('+#39+v^.text^.vs+#39+','+#39+v^.help^.vs+#39+',',v^.id,',',v^.povoleno,'),');
   if p^.dejdalsi<>nil then
      ExportujPolozku(p^.dejdalsi)
      else write(pasexp,'nil');
   write(pasexp,')');
   end
   else begin
   i:=pocet_podvetvi;
   pocet_podvetvi:=0;
   v:=p^.vazba;
   write(pasexp,Xmezer(odsazeni));
   write(pasexp,'Vetev(VytvorPolozku('+#39+v^.text^.vs+#39+','+#39+v^.help^.vs+#39+',',v^.id,',',v^.povoleno,'),');
   inc(odsazeni,POCET_MEZER);
   ExportujPolozku(p^.Vem);      {zpracuje podrazene polozky}
   if pocet_podvetvi>0 then
      write(pasexp,#13#10+Xmezer(odsazeni)+XChar(pocet_podvetvi,')'));
   dec(odsazeni,POCET_MEZER);
   pocet_podvetvi:=i+2;
   if p^.dejdalsi<>nil then
      begin
      write(pasexp,','+#13#10+Xmezer(odsazeni)+'SvazejS(');
      ExportujPolozku(p^.dejdalsi);
      end
      else begin
      dec(pocet_podvetvi);
      write(pasexp,','+#13#10+Xmezer(odsazeni)+'nil')
      end;
   end;
end;

Procedure ExportDoPAS(q:PStrom);
var s:string;
begin
s:=UlozSouborOkno('Jak to mm uloit?','menu.pas',400,true);
if s='' then Exit;
Assign(pasexp,s);
rewrite(pasexp);
ProrezStrom(q);
if q^.potomek=nil then writeln(pasexp,'p:=StromDef(nil);')
   else begin
   write(pasexp,'p:=StromDef(');
   ExportujPolozku(q^.vem);
   if pocet_podvetvi>0 then write(pasexp,#13#10+XChar(pocet_podvetvi,')'));
   write(pasexp,#13#10+');');
   end;
Close(pasexp);
pocet_podvetvi:=0;
RozvetviStrom(q);
OKokno('Povedlo se!','Soubor je uloen pod nzvem <BARVA=35264>'+s+'<SB>'+#13#10+
       'Tento soubor vlo do zdrojovho kdu svho programu.');
end;

Function SystemoveMenu(s:PStrom):longint;
var v:PPolozka;
    lm,q:PStrom;
    qb:PVybernicek;
    i,j:longint;
    x,y:longint;
    oba1,oba2:longint;

begin
def:=nil;

j:=-1;
v:=s^.vazba;
x:=(v^.x2+v^.x1) div 2;
y:=(v^.y2+v^.y1) div 2;

oba1:=BA_vyb_v;
oba2:=BA_vyb_v_akt;

BA_vyb_v:=1234;
BA_vyb_v_akt:=1234;

lm:=StromDef(UzelS(VytvorPolozku('Nov','',1,true),
             UzelS(VytvorPolozku('Nahrt','',2,true),
             UzelS(VytvorPolozku('Uloit','',3,true),
             UzelS(VytvorPolozku('Uloit do PAS zdrojku','',6,true),
             UzelS(VytvorPolozku('Npovda','',4,true),
             UzelS(VytvorPolozku('Konec <<Alt-X>>, <<Alt-F4>>','',5,true),nil
             ))))))
            );

qb:=New(PVybernicek,Init(x,y,0,lm));
BA_vyb_v:=oba1;
BA_vyb_v_akt:=oba2;


MouseRel;
q:=qb^.Vyber;
if q<>nil then
   begin
   i:=VybraneID(q);
   case i of
      1:j:=VytvorNovyStrom(s^.Root);
      2:j:=NahrajMenu;
      3:j:=UlozMenu(s^.Root);
      4:Napoveda;
      6:ExportDoPAS(s^.Root);
      5:begin klavesa:=xAltX;j:=KONEC_PROGRAMU;end;
   end;
   end;
OdstranPolozky(lm);
Dispose(qb,Done);
SystemoveMenu:=j;
end;

Function ObstarejKlavesnici(s:Pstrom;o:word;var i:longint):word;
var v:PPolozka;
    n:longint;
begin
klavesa:=o;
case o of
   xAltF4,xAltX:i:=KONEC_PROGRAMU;
   xEnter:begin
          v:=s^.vazba;
          n:=v^.id;
          if n=PRIDAVAC then i:=PridejNovouPolozku(s) else
          if n=SYST_MENU then i:=SystemoveMenu(s) else
          if s^.potomek=nil then
             if AnoNeOkno('Zalozit novy?')=true then i:=1 else
                begin
                i:=0;
                o:=0;
                end;
          end;
   end;
if i=-2 then             {debug}
   i:=i;                 {debug}
ObstarejKlavesnici:=o;
end;

Function ObstarejMys(s:PStrom;mi:mouse_record):longint;
var v:PPolozka;
    i:longint;
begin
if (mi.b and M_right)<>0 then
   begin
   if (s=nil) or (s^.vazba=nil{nemelo by nikdy nastat}) then Exit(0);
   v:=s^.vazba;
   i:=v^.id;
   if (i=PRIDAVAC) or (i=SYST_MENU) then infokno(v^.x2,v^.y2,v^.help^.p)
      else Exit(ZmenaUdaju(s));

   end;
if (mi.b and M_left)<>0 then
   begin
   if s<>nil then
      begin
      v:=s^.vazba;
      if v^.id=PRIDAVAC then Exit(PridejNovouPolozku(s));
      if v^.id=SYST_MENU then Exit(SystemoveMenu(s));
      {ted zpracujeme normalni polozky}
      if s^.potomek=nil then
         if AnoNeOkno('Zalozit novy?')=true then Exit(1) else Exit(0);
      Exit(1);
      end;
   end;
ObstarejMys:=0;
end;

Function Zeptej_se_na_udaje(q:PStrom;id:longint;nova:boolean):pointer;
const SIRKA_OKNA=300;
      VYSKA_OKNA=190;
var v:PPolozka;
    ok:TOkno_s_tlacitky;
    za:PCtverecek;
    tp1,tp2:PTextovePole;
    tp3:PMojeTextovePole;
    t1,t2:TTlacitko;
    x,y:longint;
    _text,_help:string;

    s,t:string;
    u:longint;
    bb:boolean;

begin
Zeptej_se_na_udaje:=nil;
v:=q^.vazba;
x:=(v^.x2+v^.x1) div 2;
y:=(v^.y2+v^.y1) div 2;
if nova then begin _text:='';_help:='';end
        else begin _text:=v^.text^.vs;_help:=v^.help^.vs;end;
{MouseHide;Flip_VW(zaloha_obrazovky,vga);MouseShow;}
if x+SIRKA_OKNA>=vga.Breite then x:=vga.Breite-SIRKA_OKNA-1;
if y+VYSKA_OKNA>=vga.Breite then x:=vga.Breite-VYSKA_OKNA-1;

ok.Init(x,y,SIRKA_OKNA,VYSKA_OKNA,'Definice nov poloky',w_ok+#9+w_cancel);

ok.NapisS(x+4,y+28,'<BARVA=60000>nzev poloky:<SB>');
tp1:=new(PTextovePole,init(x+4,y+44,230,_text,true,0));
ok.Pridej(tp1);

ok.NapisS(x+4,y+75,'<BARVA=60000>npovdn text:<SB>');
tp2:=new(PTextovePole,init(x+4,y+89,230,_help,false,0));
ok.Pridej(tp2);

ok.NapisS(x+4,y+120,'<BARVA=60000>ID poloky:<SB>');
tp3:=new(PMojeTextovePole,init(x+4,y+134,100,MyStr(id),false,0));
ok.Pridej(tp3);

ok.NapisS(x+193,y+130,'povoleno ?');
za:=new(PCtverecek,init(x+175,y+134,12,0));
za^.hodnota:=true;
ok.Pridej(za);
ok.Zobraz;
ok.Run;

s:='';
t:='';
bb:=za^.hodnota;
if ok.hodnota=ww_ok then
   begin
   s:=tp1^.VratHodnotu;
   t:=tp2^.VratHodnotu;
   u:=MyVal(tp3^.VratHodnotu);
   end;
ok.Done;

if s='' then Exit(nil);
Zeptej_se_na_udaje:=VytvorPolozku(s,t,u,bb);
end;

var menu:PStrom;
      vb:PVybernicek;
       q,q2:Pstrom;
       i:longint;
       p:pointer;

begin
Chdir(EXEdir);
Init;
def:=nil;
odsazeni:=0;
pocet_podvetvi:=0;
menu:=NovyStrom;
vb:=New(PVybernicek,Init(0,0,vbDOVOLVSE,menu));
vb^.VB_Mouse_R_proc:=@ObstarejMys;
vb^.VB_Key_proc:=@ObstarejKlavesnici; {nahrada defaultni obsluhy klavesnice}
menu^.InitOffspring(VytvorPolozku('<BARVA=150><<Systmov menu>><SB>','',SYST_MENU,true));
menu^.InitOffspring(VytvorPolozku(PRIDAVAC_STR,'',PRIDAVAC,true));
q:=nil;

vb^.rychly_konec:=0;
repeat
bylo_pridano:=false;
vb^.rychly_konec:=0;
vb^.UrovenZobrazeni(def);
q:=vb^.Vyber;
if q<>nil then
   begin
   i:=VybraneID(q);
   if not ((i=PRIDAVAC) or (i=SYST_MENU)) then
      begin       {Jestlize jsme klikli na polozku, tak z ni vyvedeme vetev}
      def:=q;
      q2:=New(PStrom,Init(q,nil,nil));
      q^.PridejPodstrom(q2);
      p:=VytvorPolozku(PRIDAVAC_STR,'Kliknutm na toto tlatko vytvo novou poloku',PRIDAVAC,true);
      q2^.InitNext(p);
      end;
   end else if not bylo_pridano then def:=nil;
if vb^.rychly_konec=-2 then    {v predsini ceka novy strom?}
   begin
   OdstranPolozky(menu);
   menu:=Novy_Strom;
   vb^.pozice:=menu;
   end;

MouseHide;
clr(vga,MyRGB2word(0,80,90));
MouseShow;

until (klavesa=xAltF4) or (klavesa=xAltX);

UklidProgram;
end.
