
FILE_DEVICE_BEEP				EQU	00000001h
FILE_DEVICE_CD_ROM				EQU	00000002h
FILE_DEVICE_CD_ROM_FILE_SYSTEM	EQU	00000003h
FILE_DEVICE_CONTROLLER			EQU	00000004h
FILE_DEVICE_DATALINK			EQU	00000005h
FILE_DEVICE_DFS					EQU	00000006h
FILE_DEVICE_DISK				EQU	00000007h
FILE_DEVICE_DISK_FILE_SYSTEM	EQU	00000008h
FILE_DEVICE_FILE_SYSTEM			EQU	00000009h
FILE_DEVICE_INPORT_PORT			EQU	0000000ah
FILE_DEVICE_KEYBOARD			EQU	0000000bh
FILE_DEVICE_MAILSLOT			EQU	0000000ch
FILE_DEVICE_MIDI_IN				EQU	0000000dh
FILE_DEVICE_MIDI_OUT			EQU	0000000eh
FILE_DEVICE_MOUSE				EQU	0000000fh
FILE_DEVICE_MULTI_UNC_PROVIDER	EQU	00000010h
FILE_DEVICE_NAMED_PIPE			EQU	00000011h
FILE_DEVICE_NETWORK				EQU	00000012h
FILE_DEVICE_NETWORK_BROWSER		EQU	00000013h
FILE_DEVICE_NETWORK_FILE_SYSTEM	EQU	00000014h
FILE_DEVICE_NULL				EQU	00000015h
FILE_DEVICE_PARALLEL_PORT		EQU	00000016h
FILE_DEVICE_PHYSICAL_NETCARD	EQU	00000017h
FILE_DEVICE_PRINTER				EQU	00000018h
FILE_DEVICE_SCANNER				EQU	00000019h
FILE_DEVICE_SERIAL_MOUSE_PORT	EQU	0000001ah
FILE_DEVICE_SERIAL_PORT			EQU	0000001bh
FILE_DEVICE_SCREEN				EQU	0000001ch
FILE_DEVICE_SOUND				EQU	0000001dh
FILE_DEVICE_STREAMS				EQU	0000001eh
FILE_DEVICE_TAPE				EQU	0000001fh
FILE_DEVICE_TAPE_FILE_SYSTEM	EQU	00000020h
FILE_DEVICE_TRANSPORT			EQU	00000021h
FILE_DEVICE_UNKNOWN				EQU	00000022h
FILE_DEVICE_VIDEO				EQU	00000023h
FILE_DEVICE_VIRTUAL_DISK		EQU	00000024h
FILE_DEVICE_WAVE_IN				EQU	00000025h
FILE_DEVICE_WAVE_OUT			EQU	00000026h
FILE_DEVICE_8042_PORT			EQU	00000027h
FILE_DEVICE_NETWORK_REDIRECTOR	EQU	00000028h
FILE_DEVICE_BATTERY				EQU	00000029h
FILE_DEVICE_BUS_EXTENDER		EQU	0000002ah
FILE_DEVICE_MODEM				EQU	0000002bh
FILE_DEVICE_VDM					EQU	0000002ch
FILE_DEVICE_MASS_STORAGE		EQU	0000002dh
FILE_DEVICE_SMB					EQU	0000002eh
FILE_DEVICE_KS					EQU	0000002fh
FILE_DEVICE_CHANGER				EQU	00000030h
FILE_DEVICE_SMARTCARD			EQU	00000031h
FILE_DEVICE_ACPI				EQU	00000032h
FILE_DEVICE_DVD					EQU	00000033h
FILE_DEVICE_FULLSCREEN_VIDEO	EQU	00000034h
FILE_DEVICE_DFS_FILE_SYSTEM		EQU	00000035h
FILE_DEVICE_DFS_VOLUME			EQU	00000036h
FILE_DEVICE_SERENUM				EQU	00000037h
FILE_DEVICE_TERMSRV				EQU	00000038h
FILE_DEVICE_KSEC				EQU	00000039h
FILE_DEVICE_FIPS				EQU	0000003Ah

CTL_CODE macro DeviceType,Function,Method,Access
	exitm <( DeviceType  shl  16 )  or  ( Access  shl  14 )  or  ( Function  shl  2 )  or  Method>
	endm

METHOD_BUFFERED		EQU	0
METHOD_IN_DIRECT	EQU	1
METHOD_OUT_DIRECT	EQU	2
METHOD_NEITHER		EQU	3

FILE_ANY_ACCESS		EQU	0
FILE_SPECIAL_ACCESS	EQU	FILE_ANY_ACCESS
FILE_READ_ACCESS	EQU	0001h
FILE_WRITE_ACCESS	EQU	0002h

IOCTL_SERIAL_LSRMST_INSERT		EQU	<CTL_CODE ( FILE_DEVICE_SERIAL_PORT , 31 , METHOD_BUFFERED , FILE_ANY_ACCESS )>

IOCTL_DISK_BASE					EQU	FILE_DEVICE_DISK
IOCTL_DISK_GET_DRIVE_GEOMETRY	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0000h , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_GET_PARTITION_INFO	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0001h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_SET_PARTITION_INFO	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0002h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_GET_DRIVE_LAYOUT		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0003h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_SET_DRIVE_LAYOUT		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0004h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_VERIFY				EQU	CTL_CODE ( IOCTL_DISK_BASE , 0005h , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_FORMAT_TRACKS		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0006h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_REASSIGN_BLOCKS		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0007h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_PERFORMANCE			EQU	CTL_CODE ( IOCTL_DISK_BASE , 0008h , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_IS_WRITABLE			EQU	CTL_CODE ( IOCTL_DISK_BASE , 0009h , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_LOGGING				EQU	CTL_CODE ( IOCTL_DISK_BASE , 000ah , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_FORMAT_TRACKS_EX		EQU	CTL_CODE ( IOCTL_DISK_BASE , 000bh , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_HISTOGRAM_STRUCTURE	EQU	CTL_CODE ( IOCTL_DISK_BASE , 000ch , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_HISTOGRAM_DATA		EQU	CTL_CODE ( IOCTL_DISK_BASE , 000dh , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_HISTOGRAM_RESET		EQU	CTL_CODE ( IOCTL_DISK_BASE , 000eh , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_REQUEST_STRUCTURE	EQU	CTL_CODE ( IOCTL_DISK_BASE , 000fh , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_REQUEST_DATA			EQU	CTL_CODE ( IOCTL_DISK_BASE , 0010h , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_PERFORMANCE_OFF		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0018h , METHOD_BUFFERED , FILE_ANY_ACCESS )

IOCTL_DISK_CONTROLLER_NUMBER	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0011h , METHOD_BUFFERED , FILE_ANY_ACCESS )
SMART_GET_VERSION				EQU	CTL_CODE ( IOCTL_DISK_BASE , 0020h , METHOD_BUFFERED , FILE_READ_ACCESS )
SMART_SEND_DRIVE_COMMAND		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0021h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
SMART_RCV_DRIVE_DATA			EQU	CTL_CODE ( IOCTL_DISK_BASE , 0022h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )


IOCTL_DISK_GET_PARTITION_INFO_EX	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0012h , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_SET_PARTITION_INFO_EX	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0013h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_GET_DRIVE_LAYOUT_EX		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0014h , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_SET_DRIVE_LAYOUT_EX		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0015h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_CREATE_DISK				EQU	CTL_CODE ( IOCTL_DISK_BASE , 0016h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_GET_LENGTH_INFO			EQU	CTL_CODE ( IOCTL_DISK_BASE , 0017h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_GET_DRIVE_GEOMETRY_EX	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0028h , METHOD_BUFFERED , FILE_ANY_ACCESS )


IOCTL_DISK_UPDATE_DRIVE_SIZE		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0032h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_GROW_PARTITION			EQU	CTL_CODE ( IOCTL_DISK_BASE , 0034h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_GET_CACHE_INFORMATION	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0035h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_SET_CACHE_INFORMATION	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0036h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_GET_WRITE_CACHE_STATE	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0037h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_DELETE_DRIVE_LAYOUT		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0040h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_UPDATE_PROPERTIES		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0050h , METHOD_BUFFERED , FILE_ANY_ACCESS )
IOCTL_DISK_FORMAT_DRIVE				EQU	CTL_CODE ( IOCTL_DISK_BASE , 00f3h , METHOD_BUFFERED , FILE_READ_ACCESS  or  FILE_WRITE_ACCESS )
IOCTL_DISK_SENSE_DEVICE				EQU	CTL_CODE ( IOCTL_DISK_BASE , 00f8h , METHOD_BUFFERED , FILE_ANY_ACCESS )

IOCTL_DISK_CHECK_VERIFY		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0200h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_MEDIA_REMOVAL	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0201h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_EJECT_MEDIA		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0202h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_LOAD_MEDIA		EQU	CTL_CODE ( IOCTL_DISK_BASE , 0203h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_RESERVE			EQU	CTL_CODE ( IOCTL_DISK_BASE , 0204h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_RELEASE			EQU	CTL_CODE ( IOCTL_DISK_BASE , 0205h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_FIND_NEW_DEVICES	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0206h , METHOD_BUFFERED , FILE_READ_ACCESS )
IOCTL_DISK_GET_MEDIA_TYPES	EQU	CTL_CODE ( IOCTL_DISK_BASE , 0300h , METHOD_BUFFERED , FILE_ANY_ACCESS )

IOCTL_STORAGE_BASE	EQU	<FILE_DEVICE_MASS_STORAGE>
IOCTL_STORAGE_CHECK_VERIFY	EQU	<CTL_CODE ( IOCTL_STORAGE_BASE , 0200h , METHOD_BUFFERED , FILE_READ_ACCESS )>
IOCTL_STORAGE_CHECK_VERIFY2	EQU	<CTL_CODE ( IOCTL_STORAGE_BASE , 0200h , METHOD_BUFFERED , FILE_ANY_ACCESS )>

PARTITION_ENTRY_UNUSED	EQU	00h
PARTITION_FAT_12	EQU	01h
PARTITION_XENIX_1	EQU	02h
PARTITION_XENIX_2	EQU	03h
PARTITION_FAT_16	EQU	04h
PARTITION_EXTENDED	EQU	05h
PARTITION_HUGE	EQU	06h
PARTITION_IFS	EQU	07h
PARTITION_OS2BOOTMGR	EQU	0Ah
PARTITION_FAT32	EQU	0Bh
PARTITION_FAT32_XINT13	EQU	0Ch
PARTITION_XINT13	EQU	0Eh
PARTITION_XINT13_EXTENDED	EQU	0Fh
PARTITION_PREP	EQU	41h
PARTITION_LDM	EQU	42h
PARTITION_UNIX	EQU	63h
VALID_NTFT	EQU	0C0h
PARTITION_NTFT	EQU	80h

MEDIA_TYPE typedef DWORD
Unknown = 0
F5_1Pt2_512 = 1
F3_1Pt44_512 = 2
F3_2Pt88_512 = 3
F3_20Pt8_512 = 4
F3_720_512 = 5
F5_360_512 = 6
F5_320_512 = 7
F5_320_1024 = 8
F5_180_512 = 9
F5_160_512 = 10
RemovableMedia = 11
FixedMedia = 12
F3_120M_512 = 13
F3_640_512 = 14
F5_640_512 = 15
F5_720_512 = 16
F3_1Pt2_512 = 17
F3_1Pt23_1024 = 18
F5_1Pt23_1024 = 19
F3_128Mb_512 = 20
F3_230Mb_512 = 21
F8_256_128 = 22
F3_200Mb_512 = 23
F3_240M_512 = 24
F3_32M_512 = 25

LARGE_INTEGER typedef QWORD

DISK_GEOMETRY	struct 
Cylinders		LARGE_INTEGER ?
MediaType		MEDIA_TYPE	?
TracksPerCylinder	DWORD	?
SectorsPerTrack	DWORD	?
BytesPerSector	DWORD	?
DISK_GEOMETRY	ends

PDISK_GEOMETRY typedef ptr DISK_GEOMETRY

DISK_PARTITION_INFO struct
SizeOfPartitionInfo DWORD ?
PartitionStyle		DWORD ?
union 
struct Mbr
Signature			DWORD ?
CheckSum			DWORD ?
ends
struct Gpt
DiskId				db 16 dup (?)
ends
ends
DISK_PARTITION_INFO ends

PARTITION_STYLE_MBR	equ 0
PARTITION_STYLE_GPT	equ 1

DISK_INT13_INFO struct 4
DriveSelect		WORD ?
MaxCylinders 	DWORD ?
SectorsPerTrack WORD ?
MaxHeads 		WORD ?
NumberDrives 	WORD ?
DISK_INT13_INFO ends

DISK_EX_INT13_INFO struct 8
ExBufferSize	WORD ?		;+0
ExFlags			WORD ?		;+2
ExCylinders		DWORD ?		;+4
ExHeads			DWORD ?
ExSectorsPerTrack DWORD ?	;+12
ExSectorsPerDrive QWORD ?	;+16
ExSectorSize	WORD ?		;+24
ExReserved		WORD ?
DISK_EX_INT13_INFO ends

DISK_DETECTION_INFO struct
SizeOfDetectInfo	DWORD ?			;+0	
DetectionType		DWORD ?			;+4
union
struct 
Int13		DISK_INT13_INFO <>		;+8, size 16
ExInt13		DISK_EX_INT13_INFO <>	;+24, size 32
ends
ends
DISK_DETECTION_INFO ends

DetectNone	equ 0
DetectInt13	equ 1
DetectExInt13	equ 2

DISK_GEOMETRY_EX struct 8
Geometry	DISK_GEOMETRY <>
DiskSize	QWORD ?
Data		BYTE 1 dup (?)
DISK_GEOMETRY_EX ends

;IOCTL_DISK_GET_DRIVE_GEOMETRY_EX EQU	<CTL_CODE ( IOCTL_DISK_BASE , 0028h , METHOD_BUFFERED , FILE_ANY_ACCESS )>

