
# nmake makefile, creates a "stub" HDPMI32.BIN and an
# assembly include file which is then used by a DPMILD32 
# stub version.
# tools used:
#  - JWasm | Masm
#  - JWLib | WLib (Open Watcom) | MS OMF LIB (lib16.exe)
#  - JWLink v1.8x
#  - extrmz.exe, converts stub binary to assembly include file 
#  - setmzhdr.exe, modifies MZ binary so:
#       - dos will load the 16-bit part only
#       - stack size will be 200h

!include <..\dirs>

!ifndef DEBUG
DEBUG = 0
!endif

!if $(DEBUG)
AOPTD=-Zi -D_DEBUG
LOPTD=/LI
!ifdef 386SWAT
AOPTD=$(AOPTD) -D?386SWAT=1
!endif
!endif

SRCMODS = \
!include modules.inc
OBJNAMES = $(SRCMODS:.ASM=.OBJ)
!if $(DEBUG)
OBJMODS = $(OBJNAMES:.\=STUB32D\)
!else
OBJMODS = $(OBJNAMES:.\=STUB32\)
!endif

LINK  = jwlink.exe
LOPT  = format DOS

LCMDS=$(LOPT) file $(OUTSTUB)\$(SRC).obj name $*.BIN lib $(OUTSTUB)\$(NAME).lib op q, map=$*.MAP, stack=0x200

AOPT= -nologo -c -Cp -Sg -D?32BIT=1 -D?STUB=1 $(AOPTD) -I$(INC32DIR) -Fl$* -Fo$*

NAME  = HDPMI32
SRC   = hdpmi

DEPS0 = hdpmi.inc external.inc version.inc

!if $(DEBUG)
OUTSTUB=STUB32D
!else
OUTSTUB=STUB32
!endif

.SUFFIXES: .asm .obj

.asm{$(OUTSTUB)}.obj:
	@$(ASM) $(AOPT) $<

ALL: $(OUTSTUB) $(OUTSTUB)\$(NAME).INC 

$(OUTSTUB):
	@mkdir $(OUTSTUB)

$(OBJMODS): $(DEPS0)

# create the stub version
# EXTRMZ: convert binary to asm include
# -i: create include

$(OUTSTUB)\$(NAME).INC: $*.BIN $(NAME)s.mak
	@ExtrMZ.EXE -q -i $*.BIN $*.INC

$(OUTSTUB)\$(NAME).BIN: $(OUTSTUB)\$(SRC).obj $(OUTSTUB)\$(NAME).lib $(NAME)s.mak
	$(LINK) @<<
$(LCMDS)
<<
	@SetMZHdr.exe -q $*.BIN

$(OUTSTUB)\$(NAME).lib: $(OBJMODS) $(NAME)s.mak
	@cd $(OUTSTUB)
	@$(LIB16BIN) $(NAME).lib $(OBJNAMES:.\=+)
	@jwlib -q -b $(NAME).lib -$(SRC).OBJ
	@cd ..

clean:
	@del $(OUTSTUB)\*.obj
	@del $(OUTSTUB)\*.lib
	@del $(OUTSTUB)\*.bin
	@del $(OUTSTUB)\*.lst
	@del $(OUTSTUB)\*.map
	@del $(OUTSTUB)\*.inc
