// jSH
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Linear Regression with multiple variables

function linreg_train(X, y, theta, alpha, num_iter) {
	// create copy of theta
	var TH = [];
	for (var j = 0; j < theta.length; j++) {
		TH.push(theta[j]);
	}

	// gradient descent
	var der = alpha / X.length;
	for (var ni = 0; ni < num_iter; ni++) {
		var new_theta = [];
		for (var j = 0; j < TH.length; j++) {
			new_theta.push(TH[j]);
			var sum = 0;
			for (var i = 0; i < X.length; i++) {
				var diff = linreg_predict(X[i], TH) - y[i];
				sum += diff * X[i][j];
			}
			new_theta[j] -= der * sum;
		}
		TH = new_theta; // update theta
	}

	return TH;
}

function linreg_cost(X, y, theta) {
	var sum = 0;
	for (var i = 0; i < X.length; i++) {
		var diff = linreg_predict(X[i], theta) - y[i];
		sum += diff * diff;
	}
	return sum / (2 * X.length);
}

function linreg_predict(x, theta) {
	var h_x = 0;
	for (var p = 0; p < x.length; p++) {
		h_x += theta[p] * x[p];
	}
	return h_x;
}

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

function dump(s, o) {
	Println(s + "=" + JSON.stringify(o));
}


// input values
var data = [
	[1, 26, 36, 676, 1296, 62, 1],
	[1, 28, 38, 784, 1444, 66, 1],
	[1, 31, 41, 961, 1681, 72, 1],
	[1, 33, 43, 1089, 1849, 76, 1],
	[1, 35, 45, 1225, 2025, 80, 1],
	[1, 38, 47, 1444, 2209, 85, 1],
	[1, 40, 49, 1600, 2401, 89, 1],
	[1, 44, 51, 1936, 2601, 95, 1],
	[1, 45, 51, 2025, 2601, 96, 1],
	[1, 51, 53, 2601, 2809, 104, 1],
	[1, 52, 53, 2704, 2809, 105, 1],
	[1, 56, 57, 3136, 3249, 113, 2],
	[1, 58, 58, 3364, 3364, 116, 1],
	[1, 60, 60, 3600, 3600, 120, 1],
	[1, 64, 63, 4096, 3969, 127, 1],
	[1, 67, 65, 4489, 4225, 132, 1],
	[1, 68, 65, 4624, 4225, 133, 1],
	[1, 74, 69, 5476, 4761, 143, 1],
	[1, 79, 73, 6241, 5329, 152, 1],
	[1, 82, 74, 6724, 5476, 156, 1],
	[1, 83, 74, 6889, 5476, 157, 1],
	[1, 84, 75, 7056, 5625, 159, 2],
	[1, 87, 77, 7569, 5929, 164, 1],
	[1, 90, 81, 8100, 6561, 171, 1],
	[1, 92, 82, 8464, 6724, 174, 1],
	[1, 94, 83, 8836, 6889, 177, 1],
	[1, 97, 84, 9409, 7056, 181, 1],
	[1, 99, 86, 9801, 7396, 185, 1],
	[1, 105, 90, 11025, 8100, 195, 1],
	[1, 107, 91, 11449, 8281, 198, 1],
	[1, 109, 91, 11881, 8281, 200, 1],
	[1, 110, 97, 12100, 9409, 207, 1],
	[1, 112, 91, 12544, 8281, 203, 1],
	[1, 113, 99, 12769, 9801, 212, 1],
	[1, 116, 91, 13456, 8281, 207, 1],
	[1, 116, 102, 13456, 10404, 218, 1],
	[1, 117, 106, 13689, 11236, 223, 1],
	[1, 118, 108, 13924, 11664, 226, 1],
	[1, 122, 112, 14884, 12544, 234, 1],
	[1, 125, 90, 15625, 8100, 215, 1],
	[1, 125, 115, 15625, 13225, 240, 1],
	[1, 131, 88, 17161, 7744, 219, 1],
	[1, 141, 86, 19881, 7396, 227, 1],
	[1, 143, 85, 20449, 7225, 228, 1],
	[1, 145, 85, 21025, 7225, 230, 1],
	[1, 153, 85, 23409, 7225, 238, 1],
	[1, 155, 85, 24025, 7225, 240, 1],
	[1, 157, 85, 24649, 7225, 242, 1]
];

var X = [];
var y = [];

for (var i = 0; i < data.length; i++) {
	X.push(data[i].slice(0, -1));
	y.push(data[i][data[i].length - 1]);
}

dump("X", X);
dump("y", y);

// create start values
var alpha = 0.00000001;
var num_iters = 40;

var tStart = [];
for (var j = 0; j < X[0].length; j++) {
	tStart.push(0);
}


var theta = linreg_train(X, y, tStart, alpha, num_iters);

dump("trained", theta);
dump("cost", linreg_cost(X, y, theta));
