' идеинтификаторы операций UNDO|REDO
'(1 - add symbol; 2 - BackSpace symbol; 3 - Delete symbol; 4 - insert text; 5 - Delete text ; 6 -comment ; 7 -uncomment)
enum EUNDO
	E_ADD_SYMBOL = 1
	E_BS_SYMBOL
	E_DEL_SYMBOL
	E_INS_TEXT
	E_DEL_TEXT
	E_COMMENT
	E_UNCOMMENT
End Enum

' реализация стека взята из моей библиотеки Containers
' только немного адаптирована под задачу
type TSTACKDATA
	
	As Wstring ptr pwsValue
	
	as long iPos
	
	as Byte bOperation
	
End Type

Type TSTACKNODE
	
	as TSTACKDATA xValue
	
	As TSTACKNODE Ptr pNext =0
	
End Type

Type TSTACK
	
	Declare Sub push(xParam as TSTACKDATA)
	
	Declare Function pop() As TSTACKDATA
	
	As Long iSize =0
	
	As TSTACKNODE Ptr pFirst =0
	
End Type

Sub TSTACK.push(xParam as TSTACKDATA)
	
	Dim As TSTACKNODE Ptr pTemp = New TSTACKNODE
	
	if pTemp then
		
		pTemp->xValue =xParam
		
		If pFirst =0 Then
			
			pFirst =pTemp
			
			iSize =1
			
		Else
			
			pTemp->pNext =pFirst
			
			pFirst =pTemp
			
			iSize +=1
			
		Endif
		
	else
	
		DrawErrorMemory() ' выводим ошибку памяти
		
	endif
	
End Sub

Function TSTACK.pop() As TSTACKDATA
	
	If iSize Andalso pFirst Then
		
		Dim As TSTACKNODE Ptr p = pFirst->pNext
		
		Function = pFirst->xValue
		
		Delete(pFirst)
		
		pFirst = p
		
		iSize -=1
		
	Endif
	
End Function

' Основной тип для UNDO|REDO
type UndoRedo
	
	pAccumBuf as wstring ptr ' буфер накопления данных
	
	bAccumPrev as Byte ' какая операция с буфером накопления была до этого (добавление , удаление) 
	
	iPosPrev as Long ' сохраняемая позиция вставки
	
	iPosPrevPos as Long = -100 ' предыдущая позиция для отдельных символов
	
	declare sub AddInBuf(pWData as wstring ptr , iAccumOperation as Byte , iPos as Long)
	
	declare sub AddInStack(iPos as LOng , bOper as Byte)
	
	declare sub FreeStack(iUR as Long)
	
	declare sub ClearUndo()
	
	declare sub Undo()
	
	declare sub Redo()
	
	declare sub UndoExecute(p as TSTACKDATA ptr)
	
	declare sub RedoExecute(p as TSTACKDATA ptr)
	
	declare sub URExecute(iParam as LOng , p as TSTACKDATA ptr)
	
	pStack1 as TSTACK ' 1 стек
	
	pStack2 as TSTACK ' 2 стек
	
	' флаг , отвечающий: нужно ли удалять первый узел в стэке
	'(0 - удалять ; 1 - не удалять)
	bFlagNotDeleteFirst as Byte
	
End Type

' добавляет (накапливает) символы или добавляет текст в буфер
' pWData - любой символ или текст в юникоде
' iAccumOperation - какая операция делается 
'(1 - add symbol; 2 - BackSpace symbol; 3 - Delete symbol; 4 - insert text; 5 - Delete text)
sub UndoRedo.AddInBuf(pWData as wstring ptr , iAccumOperation as Byte , iPos as Long)
	
	if pWData andalso len(*pWData) then
		
		select case iAccumOperation
				
				' если это операции (Add symbol; BackSpace symbol; Delete symbol)
			Case E_ADD_SYMBOL , E_DEL_SYMBOL , E_BS_SYMBOL
				
				dim as Long iNewPos ' позиция после прошлой операции с учетом новой операции
				
				if iAccumOperation = E_ADD_SYMBOL then ' если добавление символа
					
					iNewPos = iPosPrevPos + 1 ' посчитаем позицию
					
				elseif iAccumOperation = E_DEL_SYMBOL then ' если удаление символа (Delete Key)
					
					iNewPos = iPosPrevPos ' позиция не меняется
					
				elseif iAccumOperation = E_BS_SYMBOL then ' если удаление символа (BackSpace Key)
					
					iNewPos = iPosPrevPos - 1 ' посчитаем позицию
					
				EndIf
				
				iPosPrevPos = iPos ' сохраним позицию
				
				if bAccumPrev = iAccumOperation andalso iPos = iNewPos then ' если такая операция повторяется
					
					' выделим память с учетом имеющихся байт и новых
					pAccumBuf = reallocate(pAccumBuf , (len(*pAccumBuf)+len(*pWData)+1)*sizeof(wstring))
					
					if pAccumBuf andalso iAccumOperation = E_BS_SYMBOL then ' если это удаление по BackSpace
						
						iPosPrev = iPos ' позиция вставки сменяется на текущую
						
					elseif pAccumBuf = 0 then
					
						DrawErrorMemory() ' выводим ошибку памяти
						
					EndIf
					
				else ' это новая операция
					
					if pAccumBuf then ' если буфер заполнения уже не пустой
						
						' добавим в стэк текущий буфер
						AddInStack(iPosPrev,bAccumPrev)
						
					endif
					
					iPosPrev = iPos ' созхраним позицию вставки
					
					' выделим память с учетом новых байт
					pAccumBuf = Callocate((len(*pWData)+1)*sizeof(wstring))
					
				EndIf
				
				if pAccumBuf then
				
					if iAccumOperation = E_BS_SYMBOL then ' если после BackSpace
						
						' добавим в начало строки
						*pAccumBuf =*pWData & *pAccumBuf
						
					else ' другие нажатия
						
						' добавим в конец строки
						*pAccumBuf &=*pWData
						
					EndIf
					
					bAccumPrev = iAccumOperation ' запишем новую операцию
					
				else
				
					DrawErrorMemory() ' выводим ошибку памяти
				
				endif
				
			case else
				
				if pAccumBuf then ' если буфер заполнения уже не пустой
					
					' добавим в стэк текущий буфер
					AddInStack(iPosPrev,bAccumPrev)
					
				endif
				
				if iAccumOperation = E_COMMENT orelse iAccumOperation = E_UNCOMMENT then
					
					#ifdef __FB_DOS__
						
						' получим кол-во short символов
						dim as long iLen = LenShortBuf(cast(any ptr , pWData))
						
						' выделим память с учетом новых байт
						pAccumBuf = Callocate((iLen+1)*sizeof(TypeCommentsArraySavedRows))
						
						if pAccumBuf then
							
							' добавим в конец строки
							memcpy(pAccumBuf , pWData , (iLen)*sizeof(TypeCommentsArraySavedRows))
							
							' добавим в стэк текущий буфер
							AddInStack(iPos,iAccumOperation)
							
							iPosPrevPos = -100 ' просто не совпадающее значение
							
						else
						
							DrawErrorMemory() ' выводим ошибку памяти
						
						endif
						
						exit sub
						
					#else
						' выделим память с учетом новых байт
						pAccumBuf = Callocate((len(*pWData)+1)*sizeof(TypeCommentsArraySavedRows))
					#EndIf
					
				else
				
					' выделим память с учетом новых байт
					pAccumBuf = Callocate((len(*pWData)+1)*sizeof(wstring))
					
				EndIf
				
				if pAccumBuf then
					
					' добавим в конец строки
					*pAccumBuf &=*pWData
					
					' добавим в стэк текущий буфер
					AddInStack(iPos,iAccumOperation)
					
					iPosPrevPos = -100 ' просто не совпадающее значение
					
				else
				
					DrawErrorMemory() ' выводим ошибку памяти
				
				endif
				
		End Select
		
	endif
	
End Sub

' добавляет текущий буфер в стэк
'iPos - позиция в тексте , где было изменение
sub UndoRedo.AddInStack(iPos as LOng , bOper as Byte)
	
	FreeStack(2)
	
	' создадим структуру и заполним ее данными
	dim p as TSTACKDATA = type(pAccumBuf , iPos , bOper)
	
	' отправим в 1 стэк
	pStack1.push(p)
	
	' переменную обнуляем , но память не освобождаем , она будет хранится в стеке
	' там ее когда нужно и освободим
	pAccumBuf = 0
	
	bAccumPrev = 0
	
End Sub

' очистка стека
' iUR - какой из двух стеков очищать (1 - pStack1 ; 2 - pStack2)
sub UndoRedo.FreeStack(iUR as Long)
	
	dim as TSTACK ptr pTempStack ' указатель на стек
	
	if iUR = 1 then ' если очищаем 1 стек
		
		pTempStack = @pStack1 ' пишем в указатель 1 стек
		
	else ' иначе
		
		pTempStack = @pStack2 ' пишем в указатель 2 стек
		
	EndIf
	
	If pTempStack->iSize Then ' если размер стека не нулевой
		
		while pTempStack->pFirst ' крутится цикл , пока весь не очистим
			
			Dim As TSTACKNODE Ptr p = pTempStack->pFirst->pNext ' получим 2 узел стека
			
			' освободим память для буфера со строкой
			if (pTempStack->pFirst->xValue.pwsValue) then 
				
				deallocate(pTempStack->pFirst->xValue.pwsValue)
				
				pTempStack->pFirst->xValue.pwsValue = 0
				
			EndIf
			
			' удалим 1 узел стека
			Delete(pTempStack->pFirst)
			
			' теперь 2 узел стал первым
			pTempStack->pFirst = p
			
		Wend
		
		' размер стека ставим в ноль
		pTempStack->iSize = 0		
		
	Endif
	
End Sub

' очистка UNDO|REDO
sub UndoRedo.ClearUndo()
	
	' очистим буфер наполнения , если есть
	if pAccumBuf then 
		
		deallocate(pAccumBuf)
		
		pAccumBuf = 0
		
	EndIf
	
	' очистим 1 стэк
	FreeStack(1)
	' очистим 2 стэк
	FreeStack(2)
	' обнулим флаг
	bFlagNotDeleteFirst = 0
	
	bAccumPrev = 0
	
	iPosPrev = 0
	
	iPosPrevPos = -100
	
End Sub

' операция UNDO
sub UndoRedo.Undo()
	
	if pAccumBuf then ' если буфер заполнения уже не пустой
		
		' добавим в стэк текущий буфер
		AddInStack(iPosPrev,bAccumPrev)
		
	endif
	
	' если установлен флаг не удаления 1 узла и в стэке только 1 один узел , просто выходим
	' это нужно тогда , когда вначале загружается файл с содержимым
	' то есть начальная точка стэка должна содержать первоначальное содержимое файла
	if bFlagNotDeleteFirst = 1 andalso pStack1.iSize = 1 then
		
		SetDrawsRowsFlags(0 , -1) ' ничего не нужно перерисовывать
		
		exit sub
		
	EndIf
	
	' получим данные из 1 стэка
	dim as TSTACKDATA p = pStack1.pop()
	
	' если данные что-то содержат
	if p.bOperation then
		
		' выполнение UNDO
		UndoExecute(@p)
		
		' пересылаем эти данные во 2 стэк
		pStack2.push(p)
		
		bRepaintAnyway = 1 ' перерисовать все
		
		' флаг сохранения сбрасываем (теперь файл не сохранен)
		pObjFB.iFlagSave = 0
		
	else
	
		SetDrawsRowsFlags(0 , -1) ' ничего не нужно перерисовывать
		
		bFlagNoRePaintStatusBar = 1 ' не обновлять StatusBar
		
	EndIf
	
End Sub

' операция REDO
sub UndoRedo.Redo()
	
	if pAccumBuf then ' если буфер заполнения уже не пустой
		
		' добавим в стэк текущий буфер
		AddInStack(iPosPrev,bAccumPrev)
		
	endif
	
	' получим данные из 2 стэка
	dim as TSTACKDATA p = pStack2.pop()
	
	' если данные что-то содержат
	if p.bOperation then
		
		' выполнение REDO
		RedoExecute(@p)
		
		' пересылаем эти данные во 1 стэк
		pStack1.push(p)
		
		bRepaintAnyway = 1 ' перерисовать все
		
		' флаг сохранения сбрасываем (теперь файл не сохранен)
		pObjFB.iFlagSave = 0
		
	else
	
		SetDrawsRowsFlags(0 , -1) ' ничего не нужно перерисовывать
		
		bFlagNoRePaintStatusBar = 1 ' не обновлять StatusBar
		
	EndIf
	
End Sub

'Выполнение операции UNDO (развлетвление , в зависимости от операции)
'Параметр:
'p - указатель на данные в текущем узле стэка
sub UndoRedo.UndoExecute(p as TSTACKDATA ptr)
	
	pObj.bFlagExecuteUndo = 1 ' поставим флаг , что начали операцию откатов 
	
	select case p->bOperation ' в зависимости от типа операции разное выполнение
			
		Case E_ADD_SYMBOL , E_INS_TEXT
			
			URExecute(1 , p) ' выполнение
			
		case E_BS_SYMBOL , E_DEL_SYMBOL , E_DEL_TEXT
			
			URExecute(0 , p) ' выполнение
			
		Case E_COMMENT
		
			URExecute(2 , p) ' выполнение
			
		Case E_UNCOMMENT
		
			URExecute(3 , p) ' выполнение
			
	End Select
	
	pObj.bFlagExecuteUndo = 0 ' сбросим флаг , потому что закончили операцию откатов
	
End Sub

'Выполнение операции REDO (развлетвление , в зависимости от операции)
'Параметр:
'p - указатель на данные в текущем узле стэка
sub UndoRedo.RedoExecute(p as TSTACKDATA ptr)
	
	pObj.bFlagExecuteUndo = 2 ' поставим флаг , что начали операцию откатов
	
	select case p->bOperation ' в зависимости от типа операции разное выполнение
			
		Case E_BS_SYMBOL , E_DEL_SYMBOL , E_DEL_TEXT
			
			URExecute(1 , p) ' выполнение
			
		case E_ADD_SYMBOL , E_INS_TEXT
			
			URExecute(0 , p) ' выполнение
			
		Case E_COMMENT
		
			URExecute(3 , p) ' выполнение
			
		Case E_UNCOMMENT
		
			URExecute(2 , p) ' выполнение
			
	End Select
	
	pObj.bFlagExecuteUndo = 0 ' сбросим флаг , потому что закончили операцию откатов
	
End Sub

'Выполнение операции UNDO-REDO
'Параметры:
' iParam - что делать прямую или обратную операцию (удалять или вставлять)
' p - указатель на данные в текущем узле стэка
sub UndoRedo.URExecute(iParam as LOng , p as TSTACKDATA ptr)
	
	select case iParam
		
		Case 0 ' если надо вставлять
		
			SetPosition(p->iPos) ' установим позицию на ту , что сохранена в узле стэка
			
			InsertText(p->pwsValue) ' вставим текст+
		
		case 1 ' если надо удалять
		
			dim as long iCount ' кол-во символов окончания строки вначале строки
			
			dim as long iLen = len(*(p->pwsValue)) ' длина строки
			
			SetPosition(p->iPos) ' установим позицию на ту , что сохранена в узле стэка
			
			for i as Long = 1 to iLen ' цикл по длине символов в строке
				
				if mid(*(p->pwsValue) , i , 1) = chr(10) then ' если символ окончания
					
					DeleteKey() ' удалим его
					
					iCount+=1 ' счетчик увеличим
					
				else
					
					exit for ' выходим из цикла
					
				EndIf
				
			Next
			
			iLen-=iCount ' длину строки уменьшим на кол-во символов окончания строки
			
			if iLen then ' если длина не нулевая
				
				pObj.iMarkerSelectionStart = p->iPos ' маркер выделения на позицию , что сохранена в узле стэка
				
				SetPosition(p->iPos + iLen - 1 ) ' установим позици: маркер+длина строки
				
				DeleteSelection() ' удалим текст
				
				if right(*(p->pwsValue) , 1) = chr(10) then ' если в конце строки оказался символ окончания строки
					
					DeleteKey() ' удалим его
					
				EndIf
				
			endif
		
		case 2
			
			Uncomment(cast(any ptr , p->pwsValue) , p->iPos)
			
		case 3
		
			Comment(cast(any ptr , p->pwsValue) , p->iPos)
		
	End Select
	
End Sub

dim shared tUD as UndoRedo ' откаты назад