; E100PKT, packet driver for DOS
; Copyright (C) 2018, Seth Simon (sethsimon@sdf.org)
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see
; <https://www.gnu.org/licenses/>.

;===================
;=======     =======
;       START
;=======     =======
;===================
start:
cpu     8086
    cld             ; Assumed everywhere
    mov     ah, 9
    mov     dx, .copyright_str
    int     0x21

    call    cpu_type_or_quit
cpu     386
    call    get_args_or_quit    ; AX := int_no, or 0 to unload
    dec     ax
    js      unload
    jz      dump

    ; Otherwise load
    call    get_e100_int
    mov     dx, .e100_already_loaded_str
    jz      print_message_and_quit

    mov     al, byte [pkt_int]
    call    int_in_use
    mov     dx, .occupied_str
    jnz     print_message_and_quit
    jmp     load

.e100_already_loaded_str: db `\r\nError: E100PKT is already loaded.$`
.occupied_str: db `\r\nError: Something's already at that vector `
               db `(it's non-null).$`

.copyright_str:
db " ͻ",0xd,0xa
db "                       E100PKT 0.1, packet driver for DOS                    ",0xd,0xa
db "               Copyright (C) 2018, Seth Simon (sethsimon@sdf.org).           ",0xd,0xa
db "                                                                             ",0xd,0xa
db "  E100PKT comes with ABSOLUTELY NO WARRANTY. This is free software covered by",0xd,0xa
db "  GNU GENERAL PUBLIC LICENSE 3, and you are welcome to redistribute it under ",0xd,0xa
db "  certain conditions. See http://www.gnu.org or COPYING file for details.    ",0xd,0xa
db " ͼ",0xd,0xa
db 0xd,0xa,"$"

;====================
;=======      =======
;       UNLOAD
;=======      =======
;====================
unload:
    call    get_e100_int                ; AL := int_no
    mov     byte [.int_helper + 1], al
    mov     dx, .not_found_str
    jnz     print_message_and_quit

    ; ACCESS_TYPE
    mov     ax, 0x0201  ; funct# = 2, if_class=1
    mov     bx, -1      ; if_type = wildcard
    mov     dl, 0       ; if_number = 0
    xor     cx, cx      ; All packets
    mov     di, .receiver_helper
    call    .int_helper
    mov     dx, .failed_str
    jc      print_message_and_quit

    push    dx
    xchg    ax, bx  ; BX = handle
    mov     ah, 5   ; funct# = 5 (terminate)
    call    .int_helper
    pop     dx
    jc      print_message_and_quit
    mov     dx, .succeed_str
    jmp     print_message_and_quit_okay

.not_found_str: db `Error: E100PKT is already unloaded `
                db `or a program hooked the packet vector.$`
.succeed_str: db `Successfully unloaded E100PKT.$`
.failed_str: db `Error: Unable to terminate E100PKT.\r\n`
             db `A program may have hooked the HW vector or left `
             db `handles open.$`

.int_helper:
    int     0x60
    ret
.receiver_helper:
    xor     di, di
    mov     es, di
    iret

;==================
;=======    =======
;       LOAD
;=======    =======
;==================
load:
    call    detect_pci_bus_or_quit
    call    detect_e100_or_quit
    call    get_irq_or_quit
    call    get_csr_io_bar_or_quit
    call    timer_init
    call    self_test_or_quit
    call    get_mac_address_or_quit
    call    timer_cleanup
    call    init_cpu_memory
    call    init_pci_memory

    mov     dx, .doing_it_str
    mov     al, byte [pkt_int]
    push    ax
    call    print_str_byte
    mov     dx, .doing_it_str2
    mov     ax, cs
    call    print_str_word
    call    crlf

    mov     dx, tsr
    pop     ax
    call    set_vector

    mov     al, byte [irq_int]
    mov     dx, hw_int
    call    set_vector
    mov     di, prev_hw_int
    stosw
    xchg    ax, dx
    stosw

    call    reset_rfds
    call    toggle_irq_mask ; Unmask it
    mov     dx, tsr_end + 1
    int     0x27            ; Terminate and stay resident

.doing_it_str: db `\r\nEverything seems okay...Loading E100PKT `
               db `at INT $`
.doing_it_str2: db ` using segment $`

%include "cputype.asm"
%include "findpci.asm"
%include "get_args.asm"
%include "inite100.asm"
%include "sleep.asm"
%include "printf.asm"
%include "eeprom.asm"
%include "intstuff.asm"
%include "dump.asm"

