; E100PKT, packet driver for DOS
; Copyright (C) 2018, Seth Simon (sethsimon@sdf.org)
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see
; <https://www.gnu.org/licenses/>.

    cpu     386
    org     0x100
    jmp     start

;=================
;=======   =======
;       TSR
;=======   =======
;=================
tsr:
    jmp     .real_entry
    nop
.sig:
    db      "PKT DRVR",0
.sig2:
    db      "Intel E100 (8255x Family)",0
.sig_end:

.real_entry:
    ; When called, the stack is:
    ; - flags    BP + 8
    ; - cs       BP + 6
    ; - ip       BP + 4
    ; - bp       BP + 2
    ; - bx       BP + 0
    sti
    cld         ; Assumed everywhere
    push    bp
    push    bx
    mov     bp, sp

    and     byte [bp + 8], ~1   ; Assume no error- CLC
    dec     ah
    cmp     ah, 7
    inc     ah                  ; INC doesn't touch CF
    mov     bl, ERROR_BAD_COMMAND
    jnc     .err

    movzx   bx, ah
    add     bx, bx
    call    word [cs:bx + .func_table - 2]
    jnc     .done
.err:
    or      byte [bp + 8], 1    ; STC
    mov     dh, bl
.done:
    pop     bx
    pop     bp
    iret

.func_table: dw f_driver_info        ; AH = 1
             dw f_access_type        ; AH = 2
             dw f_release_type       ; AH = 3
             dw f_send_pkt           ; AH = 4
             dw f_terminate          ; AH = 5
             dw f_get_address        ; AH = 6
             dw f_reset_interface    ; AH = 7

%include "_1info.asm"
%include "_2access.asm"
%include "_3releas.asm"
%include "_4send.asm"
%include "_5termi.asm"
%include "_6gaddr.asm"
%include "_7reset.asm"

%include "_common.asm"
%include "_fr.asm"
%include "_handle.asm"
%include "_hw_int.asm"
%include "_rfd.asm"

absolute $      ; variables that go HERE (BSS would put them
                ; at the very end)
                ; TODO: Make sure the first 16 bytes of tcb/rfds
                ; don't overlap with the code that initializes said
                ; bytes.
    csr_io_bar:     resw 1
    pkt_int:        resb 1

    ; These 3 must stay together (see get_irq_or_quit)
    pic_port:       resw 1  ; 0x21 or 0xa1 (IRQ Mask Port)
    irq_int:        resb 1
    irq_mask:       resb 1  ; 1 << (IRQ# & 7)

    mac_address:    resb 6
    prev_hw_int:    resd 1

    alignb 2
    tcb:            resb 16 + 1518  ; metadata + packet
    alignb 2
    rfds:           resb 16 + 1518  ; metadata + packet
tsr_end:
section .text

%include "tail.asm"
