REM FoxType - an advanced UTF-8 text viewer
REM Author: Mateusz Viste "Fox"
REM Homepage: http://mateusz.viste.free.fr/dos
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
REM This program is free software; you can redistribute it and/or modify it
REM under the terms of the GNU General Public License as published by the
REM Free Software Foundation; either version 2 of the License, or (at your
REM option) any later version.
REM
REM This program is distributed in the hope that it will be useful, but
REM WITHOUT ANY WARRANTY; without even the implied warranty of
REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
REM Public License for more details.
REM
REM You should have received a copy of the GNU General Public License along
REM with this program; if not, write to the Free Software Foundation, Inc.,
REM 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
REM

TYPE BOOL AS BYTE          ' Creates a BOOL type having the BYTE properties,
CONST TRUE AS BOOL = 1     ' and handling TRUE/FALSE keywords. It is too bad
CONST FALSE AS BOOL = 0    ' that FreeBASIC doesn't provide that natively...

DECLARE SUB CzyscEkran ()
DECLARE SUB SND(ByVal freq As uInteger, dur As uInteger)
DECLARE SUB FlushKeyb ()
DECLARE SUB PrintMessage (TextMsg AS STRING)
DECLARE SUB ScreenShot ()
DECLARE SUB PrintUTF (BYVAL char AS INTEGER, BYREF Xpos AS BYTE, BYREF Ypos AS BYTE, EOFstate AS BOOL)
DECLARE SUB About ()
DECLARE SUB QuitProgram ()
DECLARE FUNCTION ChkVideoMode(xRes AS USHORT, yRes AS USHORT, ColorDept AS UBYTE) AS BOOL
DECLARE FUNCTION IgnoredChar(znak AS INTEGER) AS BOOL
DECLARE FUNCTION CurPage () AS STRING
DECLARE FUNCTION ChkBlank (char AS INTEGER) AS BOOL
DECLARE FUNCTION Bin2Dec (value AS STRING) AS USHORT
DECLARE FUNCTION Utf2Uni (UTF AS STRING) AS INTEGER
DECLARE FUNCTION RemainsBytes (BYREF ByteX AS STRING) AS BYTE

DIM SHARED WordWrapping(1 TO 81) AS INTEGER
DIM SHARED Page AS SHORT = 1
DIM SHARED GoBack AS BOOL = FALSE
DIM SHARED VideoMode AS BYTE = 1     'Uses 640x480 VGA mode by default

DIM AS STRING File

File = COMMAND(1)

IF File = "/?" OR File = "" OR LCASE(File) = "/h" OR LCASE(File) = "/help" THEN About
IF DIR(File) = "" THEN PRINT "ERROR: File '"; File; "' not found!": END (255)
IF COMMAND(2) = "/1280" OR ENVIRON("FOXTYPE") = "/1280" THEN VideoMode = 2

SELECT CASE VideoMode
    CASE 1
         IF ChkVideoMode(640, 480, 8) = FALSE THEN PRINT "ERROR: The graphic card is not VESA 1.2 compliant!": END(255)
         SCREEN 12
    CASE 2
         IF ChkVideoMode(1280, 1024, 8) = FALSE THEN PRINT "ERROR: VESA 1280x1024 resolution is not supported by the graphic card!": END(255)
         SCREEN 21
END SELECT

SETMOUSE , , 0   ' Turns off the mouse (in fact, it just makes it invisible).
CzyscEkran       ' Clears the screen (CLS can't give a blue background).

OPEN File FOR BINARY ACCESS READ AS #1

DIM Xpos AS BYTE = 1
DIM Ypos AS BYTE = 1
DIM x AS BYTE
DIM CurrChar AS INTEGER
DIM LastSpace AS UBYTE = 0
DIM AS STRING ByteX, CharString

BackPage:    ' Label used when "Back" key pressed.

DO
     IF SEEK(1) > LOF(1) THEN EXIT DO
     ByteX = INPUT(1, #1)

     CharString = ""
     CurrChar = 0
     IF RemainsBytes(ByteX) > 0 AND LOF(1) >= LOC(1) + RemainsBytes(ByteX) THEN CharString = ByteX + INPUT(RemainsBytes(ByteX), #1) ELSE CharString = ByteX

     IF LEN(CharString) > 1 THEN CurrChar = Utf2Uni(CharString) ELSE CurrChar = ASC(CharString)

     IF IgnoredChar(CurrChar) = FALSE THEN
             IF CurrChar = 32 THEN LastSpace = Xpos
             WordWrapping(Xpos) = CurrChar
             Xpos += 1

             IF Xpos = 82 OR CurrChar = 10 THEN

                     IF LastSpace = 0 OR CurrChar = 10 THEN LastSpace = Xpos - 1

                     FOR x = 1 TO LastSpace
                             IF WordWrapping(x) <> 10 THEN PrintUTF(WordWrapping(x), x, Ypos, FALSE)
                             IF GoBack = TRUE THEN GoBack = FALSE: LastSpace = 0: Xpos = 1: CzyscEkran: GOTO BackPage
                     NEXT x
                     IF WordWrapping(LastSpace) <> 32 AND WordWrapping(LastSpace) <> 10 THEN LastSpace = LastSpace - 1    ' char 10 is for ignoring empty lines between two pages.
                     FOR x = LastSpace + 1 TO (Xpos - 1)
                             WordWrapping(x - LastSpace) = WordWrapping(x)
                     NEXT x
                     Xpos -= LastSpace
                     Ypos += 1
                     LastSpace = 0
             END IF
     END IF
LOOP

FOR x = 1 TO Xpos - 2                              ' Prints out what remains
        PrintUTF(WordWrapping(x), x, Ypos, FALSE) ' in the word-wrapping
NEXT x                                             ' bufor.
PrintUTF(WordWrapping(Xpos - 1), Xpos - 1, Ypos, TRUE) ' Prints last char.

IF GoBack = TRUE THEN GoBack = FALSE: LastSpace = 0: Xpos = 1: CzyscEkran: GOTO BackPage

CLOSE #1
QuitProgram

FUNCTION ChkVideoMode(xRes AS USHORT, yRes AS USHORT, ColorDept AS UBYTE) AS BOOL
DIM Result AS BOOL = FALSE
DIM InfoData AS INTEGER

InfoData = SCREENLIST(ColorDept)

DO
      IF HIWORD(InfoData) = xRes AND LOWORD(InfoData) = yRes THEN EXIT DO
      InfoData = SCREENLIST
LOOP UNTIL InfoData = 0
IF InfoData > 0 THEN Result = TRUE

ChkVideoMode = Result
END FUNCTION

SUB About
DIM AS STRING LastKey
COLOR 7, 0
CLS
PRINT "ͻ"
PRINT "                                                                             "
PRINT "             FoxType v0.16 Copyright (C) Mateusz Viste "; CHR(34); "Fox"; CHR(34); " 2007            "
PRINT "            ------------------------------------------------------           "
PRINT "                                                                             "
PRINT " FoxType is an open-source program similar to the DOSish 'TYPE' command. The "
PRINT " main differences are  that FoxType  works in graphic  modes (so it does not "
PRINT " allow redirection nor piping) and it's able to display UTF-8 text files.    "
PRINT "                                                                             "
PRINT " USAGE:  FOXTYPE file.txt [/1280]                                            "
PRINT "                                                                             "
PRINT " The /1280 parameter switches FoxType to VESA 1280x1024 video mode.  In that "
PRINT " mode FoxType supports more Unicode characters, and the text is smoother. If "
PRINT " you would like FoxType used that video mode by default,  you should specify "
PRINT " a DOS environment variable 'FOXTYPE = /1280'.  To do that, just type in the "
PRINT " DOS prompt 'SET FOXTYPE=/1280'.                                             "
PRINT "                                                                             "
PRINT " The Unicode support isn't complete yet. I am still adding new characters to "
PRINT " the database, as I want to make it fully compliant with Unicode 3.0.        "
PRINT " Actually, unsupported characters are displayed as red '?' marks.            "
PRINT " --------------------------------------------------------------------------- "
PRINT " mateusz.viste@mail.ru                      http://mateusz.viste.free.fr/dos "
PRINT "ͼ"
PRINT
PRINT " PRESS <C> TO SEE CREDITS, <L> TO SEE THE LICENCE, OR ANY OTHER KEY TO EXIT...";

DO: SLEEP: LastKey = INKEY: LOOP UNTIL LastKey <> ""
LastKey = UCASE(LastKey)
CLS
IF LastKey = "C" THEN GOTO Credits
IF LastKey = "L" THEN GOTO Licence
END

Credits:
PRINT "ͻ"
PRINT "                                                                             "
PRINT "                                C R E D I T S                                "
PRINT "                               ---------------                               "
PRINT "                                                                             "
PRINT "                                                                             "
PRINT "                                                                             "
PRINT " People involved into the FoxType development:                               "
PRINT "                                                                             "
PRINT "                                                                             "
PRINT " Mateusz Viste 'Fox' [mateusz.viste@mail.ru]                                 "
PRINT " The author (programmer) of FoxType.                                         "
PRINT "                                                                             "
PRINT " Henrique Peron, Campo Grande, MS, Brazil [hperon@terra.com.br]              "
PRINT " Unicode fonts designer / manager.                                           "
PRINT "                                                                             "
PRINT "                                                                             "
PRINT "                                                                             "
PRINT "                                                                             "
PRINT " --------------------------------------------------------------------------- "
PRINT " mateusz.viste@mail.ru                      http://mateusz.viste.free.fr/dos "
PRINT "ͼ"
END

Licence:
PRINT "ͻ"
PRINT "                                                                             "
PRINT "                                L I C E N C E                                "
PRINT "                               ---------------                               "
PRINT "                                                                             "
PRINT " This program  is free software;  you can redistribute  it and/or modify  it "
PRINT " under the terms of the GNU General Public License  as published by the Free "
PRINT " Software Foundation;  either version 2 of the License,  or (at your option) "
PRINT " any later version.                                                          "
PRINT "                                                                             "
PRINT " This program is distributed in the hope that it will be useful, but WITHOUT "
PRINT " ANY  WARRANTY;  without even  the implied  warranty of  MERCHANTABILITY  or "
PRINT " FITNESS  FOR A PARTICULAR  PURPOSE.  See the GNU General Public License for "
PRINT " more details.                                                               "
PRINT "                                                                             "
PRINT " You should have  received a copy  of the GNU  General Public License  along "
PRINT " with this program;  if not, write to  the Free Software  Foundation,  Inc., "
PRINT " 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                    "
PRINT "                                                                             "
PRINT " --------------------------------------------------------------------------- "
PRINT " mateusz.viste@mail.ru                      http://mateusz.viste.free.fr/dos "
PRINT "ͼ"
END

END SUB

FUNCTION Bin2Dec (value AS STRING) AS USHORT ' Converts a binary number to its decimal value
DIM x AS BYTE
DIM n AS USHORT = 32768
DIM Score AS USHORT = 0

n = n / 2^(16 - LEN(value))    ' Warning: the input can't be > 16 chars!

FOR x = 0 TO LEN(value) - 1
   IF value[x] = 49 THEN Score += n      ' CHR(49) = "1"
   n = n / 2 'Could be just (32768 / 2^(x)) but that way it is much faster.
NEXT x

Bin2Dec = Score
END FUNCTION

FUNCTION ChkBlank (char AS INTEGER) AS BOOL
DIM Bajt AS STRING * 1            ' "Bajt" means "Byte" in polish :-)
DIM Result AS BOOL = FALSE

IF char <= 32 THEN
       Result = TRUE
  ELSE
       OPEN EXEPATH + "/FOXTYPE.BLN" FOR BINARY AS #2
       GET #2, 1 + INT(char / 8), Bajt
       CLOSE #2
       IF BIT(ASC(Bajt), 8 - (1 + (char MOD 8))) = 0 THEN Result = TRUE
END IF

ChkBlank = Result
END FUNCTION

FUNCTION CurPage AS STRING
DIM p AS STRING
IF Page = 0 THEN p = "***" ELSE p = LEFT(TRIM(STR(Page)) + "   ", 3)
CurPage = p
END FUNCTION

SUB CzyscEkran
'SELECT CASE VideoMode
'        CASE 1
'           LINE (0, 0)-(639, 479), 1, BF
'        CASE 2
'           LINE (0,0)-(1279,1023), 1, BF
'END SELECT
COLOR ,1
CLS
SLEEP 100
END SUB

SUB FlushKeyb
DO: LOOP UNTIL INKEY = ""   ' That is a nice keyb-flushing trick :-)
END SUB

SUB PrintMessage(TextMsg AS STRING)
DIM x AS UBYTE
FOR x = 1 TO LEN(TextMsg)
  PrintUTF(ASC(MID(TextMsg, x, 1)), x, -1, FALSE)
NEXT x
END SUB

SUB PrintUTF (BYVAL char AS INTEGER, BYREF Xpos AS BYTE, BYREF Ypos AS BYTE, EOFstate AS BOOL)
DIM AS BYTE x, y
DIM kolorek AS BYTE = 7
DIM Empty AS BOOL = TRUE
DIM AS STRING * 1 t1, t2
DIM VarText AS STRING * 19
DIM Table(1 TO 32) AS STRING * 16
DIM AS STRING LastKey

IF char = -1 THEN char = 63: kolorek = 4
IF Ypos = -1 THEN Empty = FALSE ' Disabling unknown chars detection for messages.

Unsupported:

SELECT CASE VideoMode
     CASE 1
        OPEN EXEPATH + "/FOXTYPE.640" FOR BINARY ACCESS READ AS #2
        FOR x = 1 TO 16
           GET #2, char * 16 + x, Table(x)
           Table(x) = BIN(ASC(Table(x)), 8)
           IF Table(x) <> "00000000" THEN Empty = FALSE
        NEXT x
     CASE 2
        OPEN EXEPATH + "/FOXTYPE.DAT" FOR BINARY ACCESS READ AS #2
        FOR x = 1 TO 32
          GET #2, char * 64 + (2 * x) - 1, t1
          GET #2, char * 64 + (2 * x), t2
          Table(x) = BIN(ASC(t1), 8) + BIN(ASC(t2), 8)
          IF Table(x) <> "0000000000000000" THEN Empty = FALSE
        NEXT x
END SELECT
CLOSE #2

IF Empty = TRUE THEN                      ' Can't use "IF xx AND xx" here, as
        IF ChkBlank(char) = FALSE THEN    ' it would considerably slow down
           kolorek = 4                    ' the whole program!
           char = 63                      '
           Empty = FALSE                  ' To avoid loop if char #63 empty.
           GOTO Unsupported               '
        END IF                            ' Remember, that passing "char" as
END IF                                    ' "BYVAL" is very important too!

IF Ypos >= 28 + (VideoMode * 2) OR EOFstate = TRUE THEN
  Ypos = 1

  DO
       IF EOFstate = FALSE THEN
            VarText = "  [Spc] - continue,"
         ELSE
            VarText = "[End Of File]      "
       END IF
       PrintMessage("Page " + CurPage + " " + VarText + " [BackSpc] - Back, [S] - Screenshot, [Esc] - Quit...")
       FlushKeyb
       DO: SLEEP: LastKey = INKEY: LOOP UNTIL LastKey <> ""
       LastKey = UCASE(LastKey)
       IF LastKey = CHR(8) AND Page > 1 THEN
             SEEK #1, 1    ' Should be SEEK #1, <prev_page_offset>
             Page = 1      ' Should be Page = Page - 1
             GoBack = TRUE
             EXIT DO
       END IF
       IF LastKey = "S" THEN ScreenShot
       IF LastKey = CHR(27) THEN EXIT DO
       IF LastKey = " " AND EOFstate = FALSE THEN
            IF Page < 999 AND Page > 0 THEN Page += 1 ELSE Page = 0
            EXIT DO
       END IF
  LOOP
  IF LastKey = CHR(27) THEN QuitProgram
  IF GoBack = FALSE AND EOFstate = FALSE THEN CzyscEkran
END IF

IF Ypos = -1 THEN Ypos = 28 + (VideoMode * 2): kolorek = 14

DIM AS ANY PTR gSprite         ' Create variable for the char sprite
gSprite = ImageCreate(8 * VideoMode, 16 * VideoMode, 0) 'Allocate memory for char

IF Empty = FALSE OR kolorek = 14 THEN
        FOR y = 1 TO 16 * VideoMode
          FOR x = 1 TO 8 * VideoMode
            IF MID(Table(y), x, 1) = "1" THEN
                   PSET gSprite, (x - 1, y - 1), kolorek
                ELSE
                   IF kolorek = 14 THEN PSET ((Xpos - 1) * 8 * VideoMode + x - 1, (Ypos - 1) * 16 * VideoMode + y - 1), 0 ' Zero color must be written directly to screen. The PUT command ignores it.
            END IF
          NEXT x
        NEXT y
END IF

PUT ((Xpos - 1) * 8 * VideoMode, (Ypos - 1) * 16 * VideoMode), gSprite, TRANS
ImageDestroy(gSprite)      ' Unallocate char's memory

END SUB


FUNCTION RemainsBytes(BYREF ByteX AS STRING) AS BYTE
DIM Remm AS BYTE = -1
DIM t AS BOOL = TRUE
DIM x AS BYTE
DIM AS STRING a

a = BIN(ASC(ByteX), 8)

FOR x = 1 TO LEN(a)
  IF MID(a, x, 1) = "1" AND t = TRUE THEN Remm += 1 ELSE t = FALSE
NEXT x

IF Remm > 3 THEN Remm = 0       ' Protection against malformed UTF8 chars

RemainsBytes = Remm
END FUNCTION

SUB ScreenShot
DIM AS SHORT MaxXres, MaxYres, x, y
DIM kolor AS UBYTE
DIM t AS STRING * 1
DIM AS STRING NazwaPliku

DO
   x += 1
   NazwaPliku = EXEPATH + "/SHOT" + RIGHT("0000" + RTRIM(LTRIM(STR(x))), 4) + ".BMP"
LOOP UNTIL DIR(NazwaPliku) = "" OR x = 9999

ON ERROR GOTO ErrHandler

SND(300, 2)

OPEN NazwaPliku FOR OUTPUT AS #4
OPEN EXEPATH + "/FOXTYPE.BIN" FOR BINARY AS #3

SELECT CASE VideoMode
        CASE 1
          MaxXres = 640
          MaxYres = 480
        CASE 2
          SEEK #3, 1079
          MaxXres = 1280
          MaxYres = 1024
END SELECT

FOR x = 1 TO 1078
        GET #3, SEEK(3), t
        PRINT #4, t;
NEXT x
CLOSE #3

FOR y = MaxYres - 1 TO 0 STEP -1
        IF y = MaxYres - (17 * VideoMode) THEN PrintMessage("                             ***  PLEASE  WAIT  ***                             ")
        FOR x = 0 TO MaxXres - 1
                kolor = POINT(x, y)
                PRINT #4, CHR(kolor);
        NEXT x
NEXT y

CLOSE #4
ON ERROR GOTO 0      ' Disabling error handling

SND(800, 1)

GOTO SkipErrHandler

ErrHandler:
        CLOSE
        SCREEN 0: CLS
        PRINT "Current drive seems to be read-only. Screenshot failed!"
        END (255)

SkipErrHandler:

END SUB


SUB SND(ByVal freq AS UINTEGER, dur AS UINTEGER)
   DIM t AS DOUBLE, f1 AS USHORT
   IF freq > 0 THEN
      f1 = 1193181 \ freq
      OUT &H61, INP(&H61) OR 3
      OUT &H43, &HB6
      OUT &H42, lobyte(f1)
      OUT &H42, hibyte(f1)
   END IF
   t = TIMER
   WHILE ((TIMER - t) * 1000) < dur
      SLEEP 0, 1
   WEND
   IF freq > 0 THEN
      OUT &H61, INP(&H61) AND &HFC
   END IF
END SUB


FUNCTION Utf2Uni(UTF AS STRING) AS INTEGER
REM
REM This function translates an UTF-8 character to its unicode value.
REM
DIM Table(1 TO 4) AS STRING
DIM x AS BYTE
DIM Result AS INTEGER = -1
DIM Unicode AS STRING

FOR x = 1 TO LEN(UTF)
     Table(x) = BIN(ASC(MID(UTF, x, 1)), 8)
     Table(x) = MID(Table(x), 3, LEN(Table(x)) - 2)
NEXT x

IF LEN(UTF) > 1 THEN Table(1) = MID(Table(1), LEN(UTF), LEN(Table(1)) - LEN(UTF) + 1)

Unicode = ""
FOR x = 1 TO LEN(UTF)
     Unicode = Unicode + Table(x)
NEXT x

REM Here is a protection against characters > 65535, which are out of the
REM FoxType database adressing.
IF LEN(Unicode) <= 16 THEN Result = Bin2Dec(Unicode)

Utf2Uni = Result
END FUNCTION

SUB QuitProgram
DIM AS UBYTE x, y
DIM R(1 TO 3) AS INTEGER        ' It could be USHORT, but must be INTEGER,
DIM G(1 TO 3) AS INTEGER        ' otherwise the PALETTE command will not
DIM B(1 TO 3) AS INTEGER        ' accepts it.
DIM IndexColor (1 TO 3) AS UBYTE = {1, 7, 14}

FOR x = 1 TO 3
        PALETTE GET IndexColor(x), R(x), G(x), B(x)
NEXT x
FOR x = 0 TO 5
     FOR y = 1 TO 3
           IF R(y) >= 20 THEN R(y) -= 20
           IF G(y) >= 20 THEN G(y) -= 20
           IF B(y) >= 20 THEN B(y) -= 20
           PALETTE IndexColor(y), R(y), G(y), B(y)
           SLEEP 60, 1
     NEXT y
NEXT x

CLOSE : SCREEN 0: CLS : END
END SUB

FUNCTION IgnoredChar(znak AS INTEGER) AS BOOL
 DIM Answer AS BOOL = FALSE
 IF znak = 65534 OR znak = 65279 OR znak = 13 THEN Answer = TRUE
 IgnoredChar = Answer
END FUNCTION
