DECLARE FUNCTION BIN$ (numb&)
DECLARE FUNCTION Bin2Dec& (value$)
DECLARE FUNCTION Utf2Uni& (UTF$)
DECLARE FUNCTION RemainsBytes% (ByteX$)

DO
ByteX$ = INPUT$(1)
IF ByteX$ = "" THEN EXIT DO

CharString$ = ""
Char& = 0
IF RemainsBytes%(ByteX$) > 0 THEN CharString$ = ByteX$ + INPUT$(RemainsBytes%(ByteX$)) ELSE CharString$ = ByteX$

IF LEN(CharString$) > 1 THEN Char& = Utf2Uni&(CharString$) ELSE Char& = ASC(CharString$)

PRINT "<" + HEX$(Char&) + "> ";
LOOP

END

FUNCTION BIN$ (numb&)
REM
REM  Function BIN$ - Converts a decimal number to its binary value
REM
REM  Warning: This function works only with numbers 0..999999 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
x& = 0
wynik$ = ""
dzielnik& = 524288
DO
n& = numb& \ dzielnik& MOD 2
dzielnik& = dzielnik& / 2
x& = x& + n&
IF NOT x& = 0 THEN wynik$ = wynik$ + LTRIM$(STR$(n&))
LOOP UNTIL dzielnik& = 0
IF x& = 0 THEN wynik$ = "0"
wynik$ = RIGHT$("00000000" + wynik$, 8)

BIN$ = wynik$
END FUNCTION

FUNCTION Bin2Dec& (value$)
REM
REM  Function Bin2Dec - Converts a binary number to its decimal value
REM
REM  Warning: This function works only with numbers 0..1111111111111111 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
DIM Table(1 TO 16) AS INTEGER
value$ = RIGHT$("0000000000000000" + value$, 16)

n = 32768
Score& = 0

FOR x% = 1 TO 16
  Table(x%) = VAL(MID$(value$, x%, 1))
  Score& = Score& + Table(x%) * n
  n = n / 2
NEXT x%

Bin2Dec& = Score&
END FUNCTION

FUNCTION RemainsBytes% (ByteX$)

a$ = BIN$(ASC(ByteX$))

Remm% = -1
t% = 1

FOR x% = 1 TO LEN(a$)
  IF MID$(a$, x%, 1) = "1" AND t% = 1 THEN Remm% = Remm% + 1 ELSE t% = 0
NEXT x%

IF Remm% > 3 THEN Remm% = 0       ' Protection against malformed UTF8 chars

RemainsBytes = Remm%
END FUNCTION

FUNCTION Utf2Uni& (UTF$)
REM
REM This function translates an UTF-8 character to its unicode value.
REM

DIM Table(1 TO 4) AS STRING

FOR x% = 1 TO LEN(UTF$)
     Table(x%) = BIN$(ASC(MID$(UTF$, x%, 1)))
     Table(x%) = MID$(Table(x%), 3, LEN(Table(x%)) - 2)
NEXT x%

IF LEN(UTF$) > 1 THEN Table(1) = MID$(Table(1), LEN(UTF$), LEN(Table(1)) - LEN(UTF$) + 1)

Unicode$ = ""
FOR x% = 1 TO LEN(UTF$)
     Unicode$ = Unicode$ + Table(x%)
NEXT x%

REM Here is a protection against characters > 65535, which are out of the
REM FoxType database adressing.
REM
IF LEN(Unicode$) <= 16 THEN Result& = Bin2Dec&(Unicode$) ELSE Result& = -1

Utf2Uni& = Result&
END FUNCTION

