/*	$Id$

 *  Perform an option check and parse value for boolean

	This file bases on CMDLINE.C of FreeCOM v0.81 beta 1.

	$Log$
	Revision 1.4  2005/12/10 10:09:43  perditionc
	based on patches from Blair Campbell, additional LFN support (slim print,
	add initial cd,rd,md support, make compile time optional), remove some
	compiler warnings, and prevent extra linebreak for compatibility

	Revision 1.3  2005/09/03 18:15:10  perditionc
	dir /p /p works same as dir /p
	
	Revision 1.2  2004/02/01 13:52:17  skaus
	add/upd: CVS $id$ keywords to/of files
	
	Revision 1.1  2001/04/12 00:33:53  skaus
	chg: new structure
	chg: If DEBUG enabled, no available commands are displayed on startup
	fix: PTCHSIZE also patches min extra size to force to have this amount
	   of memory available on start
	bugfix: CALL doesn't reset options
	add: PTCHSIZE to patch heap size
	add: VSPAWN, /SWAP switch, .SWP resource handling
	bugfix: COMMAND.COM A:\
	bugfix: CALL: if swapOnExec == ERROR, no change of swapOnExec allowed
	add: command MEMORY
	bugfix: runExtension(): destroys command[-2]
	add: clean.bat
	add: localized CRITER strings
	chg: use LNG files for hard-coded strings (hangForEver(), init.c)
		via STRINGS.LIB
	add: DEL.C, COPY.C, CBREAK.C: STRINGS-based prompts
	add: fixstrs.c: prompts & symbolic keys
	add: fixstrs.c: backslash escape sequences
	add: version IDs to DEFAULT.LNG and validation to FIXSTRS.C
	chg: splitted code apart into LIB\*.c and CMD\*.c
	bugfix: IF is now using error system & STRINGS to report errors
	add: CALL: /N
	
 */

#include "../config.h"

#include <assert.h>
#include <process.h>
#include <stdio.h>

#include "../include/command.h"
#include "../include/cmdline.h"
#include "../err_fcts.h"

int optScanBool_(const char * const optstr, int bool, const char *arg, int *value, int flip)
{
  assert(optstr);
  assert(value);

  if(arg) {
    error_opt_arg(optstr);
    return E_Useage;
  }
  switch(bool) {
  case -1:  *value = 0; break;
  case 0:   if (flip) {*value = !*value; break; } /* else fall through to case 1 */
  case 1:   *value = 1; break;
#ifndef NDEBUG
  default:  fprintf(stderr, "Invalid boolean option value: in file %s line %u\n", __FILE__, __LINE__);
    abort();
#endif
  }
  return 0;
}
