unit barvy;
{ Barvy }
{
  Tato jednotka je soucasti baliku Wokna32 od Laaci.
  Zde jsou deklarace objektu pouzitelnych pri vyberu amichani barev. Predpo-
  kladam, ze v hlavnim programu tyto funkce nebudou obvykle volany primo, ale
  skrze vysokourovnove procedury z jednotky Nadwokna
                                            ---------
}
{}
{$INCLUDE defines.inc}

interface
uses Wokna32,VenomGFX;

type

PDuha = ^TDuha;
TDuha = object(TWoknaZaklad)
      duhaimg:PVirtualwindow;
      Constructor Init(ix,iy:longint);
      Procedure ZobrazMe;virtual;
      Destructor Done;virtual;
      end;

PVyberBarvuOkno =^TVyberBarvuOkno;
TVyberBarvuOkno = object(TOkno_s_tlacitky)
      stara,vybrana:byte;
      lhx,lhy:longint;
      vel_ctverecku:longint;
      def:byte;
      Constructor Init(ix,iy,ivel:longint;titulek:string;idefault:byte);
      Function VratHodnotu:word;
      Procedure Kontrola;virtual;
      Procedure ZmenPozici(ix,iy:longint);virtual;
      Procedure ZobrazMe;virtual;
      Procedure ZobrazZadane;
      Destructor Done;virtual;
      end;

PVyberBarvu16Okno = ^TVyberBarvu16Okno;
TVyberBarvu16Okno = object(TOkno_s_tlacitky)
      def,vybrana:word;
      lhx,lhy:longint;
      duha:PDuha;
      cga_p:array[0..15] of PObdelnik;
      Constructor Init(ix,iy:longint;titulek:string;defaultb:word);
      Function VratHodnotu:word;
      Procedure Kontrola;virtual;
      Procedure VolejPaletu;
      Procedure VolejMixer;
      Procedure ZmenPozici(ix,iy:longint);virtual;
      Procedure ZobrazMe;virtual;
      Procedure ZobrazZadane;
      Destructor Done;virtual;
      end;


PMixBarvuOkno = ^TMixBarvuOkno;
TMixBarvuOkno = object(TOkno_s_tlacitky)
      lhx,lhy:longint;
      def,vybrana:longint;
      r,g,b:PPosuvnik;
      Constructor Init(ix,iy:longint;titulek:string;default:word);
      Function VratHodnotu:word;
      Procedure ZobrazMe;virtual;
      Procedure ZobrazZadane;
      Procedure ZmenPozici(ix,iy:longint);virtual;
      Procedure Kontrola;virtual;
      Destructor Done;virtual;
      end;



implementation
uses Rezklav,Lacrt,Vaznik,Woknadef,TEdRadky,FNfont3;


Constructor TDuha.Init(ix,iy:longint);
var i,j:longint;
begin
inherited Init;
x:=ix;
y:=iy;
sirka:=128+128;
vyska:=128+128;
New(duhaimg);
Init_VW(duhaimg^,sirka,vyska,false);
for i:=0 to 127 do for j:=0 to 127 do PutPixel(duhaimg^,127-i,127-j,MyRGB2word(i*2,j*2,0));
for i:=0 to 127 do for j:=0 to 127 do PutPixel(duhaimg^,i+128,127-j,MyRGB2word(i+j,i+j,i+j));
for i:=0 to 127 do for j:=0 to 127 do PutPixel(duhaimg^,127-i,j+128,MyRGB2word(i*2,0,j*2));
for i:=0 to 127 do for j:=0 to 127 do PutPixel(duhaimg^,i+128,j+128,MyRGB2word(0,i*2,j*2));
end;


Procedure TDuha.ZobrazMe;
begin
MouseHide;
PutClippedSprite(cil^,duhaimg^,x,y);
MouseShow;
end;


Destructor TDuha.Done;
begin
Kill_VW(duhaimg^);
Dispose(duhaimg);
end;


Constructor TvyberBarvuOkno.Init(ix,iy,ivel:longint;titulek:string;idefault:byte);
var i:longint;
begin
i:=ROZESTUP_TLACITEK;
ROZESTUP_TLACITEK:=36;   {budeme potrebovat vetsi rozestup tlacitek nez std.}
inherited Init(ix,iy,titulek,w_ok+#9+w_CANCEL);
stara:=idefault;
vybrana:=idefault;
def:=idefault;
vel_ctverecku:=ivel;
Roztahni(16*vel_ctverecku+4,16*vel_ctverecku+VyskaZahlavi+VyskaDolniRadyTlacitek+6);
{roztazeni okna (prislusne premisti i dolni tlacitka)}
lhx:=x+2;
lhy:=y+VyskaZahlavi;
ROZESTUP_TLACITEK:=i;
end;


Procedure TVyberBarvuOkno.ZmenPozici(ix,iy:longint);
begin
inc(lhx,ix-x);
inc(lhy,iy-y);
inherited ZmenPozici(ix,iy);
end;


Procedure TVyberBarvuOkno.Kontrola;
begin
inherited Kontrola;
if Retez^.VyznamAktivniho(akt_bez)=ww_Zrus then vybrana:=def;
if Mouse_L and MouseInArea(lhx,lhy,lhx+16*vel_ctverecku-1,lhy+16*vel_ctverecku-1) then
   begin
   vybrana:=(mouse.x-lhx) div vel_ctverecku+((mouse.y-lhy) div vel_ctverecku)shl 4;
   if vybrana<>stara then
      begin
      ZobrazZadane;
      stara:=vybrana;
      end;
   MouseRel;
   end;
end;

Function TVyberBarvuOkno.VratHodnotu:word;
begin
if hodnota=ww_ok
   then VratHodnotu:=vga2word(vybrana)
   else VratHodnotu:=vga2word(def);
end;

Procedure TVyberBarvuOkno.ZobrazZadane;
var s:string;
    v:PItRadek;
    u1,u2:PTlacitko;
    u1x2,xstred:longint;

    vyband15_velctv:longint;
    vybshr4_velctv:longint;

    staand15_velctv:longint;
    stashr4_velctv:longint;

    velctv_m1,velctv_m2:longint;

begin
MouseHide;
u1:=retez^.Uzel(1);
u2:=retez^.Uzel(2);

vyband15_velctv:=(vybrana and 15)*vel_ctverecku;
vybshr4_velctv:=(vybrana shr 4)*vel_ctverecku;

staand15_velctv:=(stara and 15)*vel_ctverecku;
stashr4_velctv:=(stara shr 4)*vel_ctverecku;

velctv_m1:=vel_ctverecku-1;
velctv_m2:=vel_ctverecku-2;

Bar(cil^,staand15_velctv+lhx,stashr4_velctv+lhy,staand15_velctv+lhx+velctv_m1,stashr4_velctv+lhy+velctv_m1,vga2word(stara));
rectangle(cil^,vyband15_velctv+lhx+1,vybshr4_velctv+lhy+1,vyband15_velctv+lhx+velctv_m1,vybshr4_velctv+lhy+velctv_m1,0);
rectangle(cil^,vyband15_velctv+lhx,vybshr4_velctv+lhy,vyband15_velctv+lhx+velctv_m2,vybshr4_velctv+lhy+velctv_m2,65514);

Str(vybrana,s);s:=s+#0;
v:=Tagy_na_vaznik(@s[1],Length(s),nil);

u1x2:=u1^.x+u1^.sirka+1;

Bar(cil^,u1x2,u1^.y,u2^.x-1,u2^.y+u2^.vyska-1,BA_okn_v);

xstred:=(u1x2+u2^.x-1) div 2;

Print_IT(xstred - (v^.gd div 2),u1^.y+u1^.vyska-4,v);
Dispose(v,Done);
MouseShow;
end;

Procedure TVyberBarvuOkno.ZobrazMe;
var i,j:longint;
    n:longint;
begin
inherited ZobrazMe;
MouseHide;
for i:=0 to 15 do
   for j:=0 to 15 do {barvy}
      Bar(cil^,lhx+vel_ctverecku*j,
               lhy+vel_ctverecku*i,
               lhx+vel_ctverecku*j+(vel_ctverecku-1),
               lhy+vel_ctverecku*i+(vel_ctverecku-1),vga2word(i shl 4+j));
MouseShow;
ZobrazZadane;
end;

Destructor TVyberBarvuOkno.Done;
begin
inherited Done;
end;


Constructor TMixBarvuOkno.Init(ix,iy:longint;titulek:string;default:word);
var v1,v2:PTlacitko;
    i,s:longint;
    rh,gh,bh:byte;

begin
inherited Init(ix,iy,titulek,w_ok+#9+w_CANCEL);
Roztahni(350,150);
lhx:=x+2;
lhy:=y+VyskaZahlavi;

i:=retez^.NejsirsiObjekt_longint;
Repozice_tlacitek_srovnej_pod_sebe(x+sirka-i-5,y+VyskaZahlavi+1,i,2);

s:=sirka-4;
vybrana:=default;
def:=default;
word2RGB(vybrana,rh,gh,bh);
r:=New(PPosuvnik,Init(lhx,lhy+60,s,32*s,rh*s,s,poHORZ,10));
r^.BB_pos_v:=64000;
r^.BB_pos_str_v:=58383;
r^.tlac1.BB_tla_v:=64000;
r^.tlac2.BB_tla_v:=64000;

g:=New(PPosuvnik,Init(lhx,lhy+80,s,64*s,gh*s,s,poHORZ,20));
g^.BB_pos_v:=1344;
g^.BB_pos_str_v:=40723;
g^.tlac1.BB_tla_v:=1344;
g^.tlac2.BB_tla_v:=1344;

b:=New(PPosuvnik,Init(lhx,lhy+100,s,32*s,bh*s,s,poHORZ,30));
b^.BB_pos_v:=30;
b^.BB_pos_str_v:=36092;
b^.tlac1.BB_tla_v:=30;
b^.tlac2.BB_tla_v:=30;

Retez^.Pridej(r);
Retez^.Pridej(g);
Retez^.Pridej(b);
end;


Procedure TMixBarvuOkno.ZmenPozici(ix,iy:longint);
begin
inc(lhx,ix-x);
inc(lhy,iy-y);
inherited ZmenPozici(ix,iy);
end;


Procedure TMixBarvuOkno.Kontrola;
begin
inherited Kontrola;
if r^.kopozitiv  or g^.kopozitiv or b^.kopozitiv then
   begin

   ZobrazZadane;
   end;
if Retez^.VyznamAktivniho(akt_bez)=ww_Zrus then vybrana:=def;
end;

Procedure TMixBarvuokno.ZobrazMe;
begin
inherited ZobrazMe;
ZobrazZadane;
end;

Procedure TMixBarvuOkno.ZobrazZadane;
var mix:word;
    ff:word;
    rh,gh,bh:byte;
    rr,gg,bb,s:longint;

begin
s:=sirka-4;
rh:=r^.hodnota div s;
gh:=g^.hodnota div s;
bh:=b^.hodnota div s;

mix:=RGB2word(rh,gh,bh);
MouseHide;
Bar(cil^,lhx+71,lhy,lhx+250,lhy+59,BA_okn_v);
Bar(cil^,lhx+1,lhy+5,lhx+69,lhy+39,mix);
Print_FN(lhx+155,lhy+15,Mystr(rh));
Print_FN(lhx+155,lhy+31,Mystr(gh));
Print_FN(lhx+155,lhy+47,Mystr(bh));
ff:=FN_color;
FN_color:=65535;
Rectangle(cil^,lhx+182,lhy+15,lhx+248,lhy+32,0);
Print_FNTag(x+185,lhy+31,'= '+Mystr(mix),nil);
FN_color:=ff;

rh:=round(rh/31*255);
gh:=round(gh/63*255);
bh:=round(bh/31*255);

Print_FN(lhx+80,lhy+15,Mystr(rh));
Print_FN(lhx+80,lhy+31,Mystr(gh));
Print_FN(lhx+80,lhy+47,Mystr(bh));
Print_FN(lhx+110,lhy+15,'(#'+dec2hex(rh)+')');
Print_FN(lhx+110,lhy+31,'(#'+dec2hex(gh)+')');
Print_FN(lhx+110,lhy+47,'(#'+dec2hex(bh)+')');
MouseShow;
vybrana:=mix;
end;

Function TMixBarvuOkno.VratHodnotu:word;
begin
if hodnota=ww_ok
   then VratHodnotu:=vybrana
   else VratHodnotu:=def;
end;

Destructor TMixBarvuOkno.Done;
begin
inherited Done;
end;

Constructor TVyberBarvu16Okno.Init(ix,iy:longint;titulek:string;defaultb:word);
var v1,v2:PTlacitko;
    chx,chy,b:longint;
begin
inherited Init(ix,iy,titulek,w_ok+#9+w_CANCEL+#9+w_PALETA);
v2:=Retez^.Uzel(2);
v1:=New(PTlacitko,Init(0,0,w_MIXBAREV,0,2,0));  {pridame tl.mixbarev}
v1^.fixmode_y(1);
v1^.ZmenPozici(v2^.x,v2^.y-v2^.vyska-5);
Pridej(v1);
vybrana:=defaultb;
def:=defaultb;
Roztahni(260,280+vyska+v1^.vyska+1);  {roztazeni okna}
lhx:=x+2;
lhy:=y+VyskaZahlavi;


duha:=New(PDuha,Init(lhx,lhy));
Retez^.Pridej(duha);

chx:=lhx;
chy:=duha^.y+duha^.vyska+4;

for b:=0 to 15 do
    begin
    cga_p[b]:=New(PObdelnik,Init(chx,chy,16,16,vga2word(b),100+b));
    Retez^.Pridej(cga_p[b]);
    inc(chx,cga_p[b]^.sirka);
    end;

end;


Procedure TVyberBarvu16Okno.ZmenPozici(ix,iy:longint);
begin
inc(lhx,ix-x);
inc(lhy,iy-y);
inherited ZmenPozici(ix,iy);
end;


Function TVyberBarvu16Okno.VratHodnotu:word;
begin
if hodnota=ww_ok
   then VratHodnotu:=vybrana
   else VratHodnotu:=def;
end;

Procedure TVyberBarvu16Okno.VolejPaletu;
var t:TVyberBarvuOkno;
begin
t.init(NA_STRED+40,NA_STRED+40,16,w_paleta,15);
t.zobraz;
t.run;
if t.retez^.VyznamAktivniho(akt_bez)<>ww_zrus then vybrana:=t.VratHodnotu;
t.done;
end;

Procedure TVyberBarvu16Okno.VolejMixer;
var t:TMixBarvuOkno;
begin
t.init(NA_STRED,NA_STRED,w_mixbarev,vybrana);
t.zobraz;
t.run;
if t.retez^.VyznamAktivniho(akt_bez)<>ww_zrus then vybrana:=t.VratHodnotu;
t.done;
end;


Procedure TVyberBarvu16Okno.ZobrazZadane;
var v:PTlacitko;
begin
v:=Retez^.Uzel(4);
MouseHide;
Bar(cil^,lhx,v^.y,v^.x-1,v^.y+v^.vyska,BA_okn_v);
Bar(cil^,lhx+1,v^.y+1,lhx+15,v^.y+15,vybrana);
Rectangle(cil^,lhx,v^.y,lhx+16,v^.y+16,0);
Print_FNTag(lhx+21,v^.y+15,MyStr(vybrana),nil);

Bar(cil^,x+2,cga_p[0]^.y-2,x+sirka-2,cga_p[0]^.y-1,492);
Bar(cil^,x+2,cga_p[0]^.y+16,x+sirka-2,cga_p[0]^.y+16+1,492);

MouseShow;
end;

Procedure TVyberBarvu16Okno.Kontrola;
var va:longint;
begin
inherited Kontrola;
va:=Retez^.VyznamAktivniho(akt_bez);

if va=ww_paleta then
   begin
   VolejPaletu;
   ZobrazZadane;
   end;

if va=ww_mixbarev then
   begin
   VolejMixer;
   ZobrazZadane;
   end;



if (va>=100) and (va<=115) then
   begin
   vybrana:=vga2word(va-100);
   ZobrazZadane;
   MouseRel;
   end;

if Mouse_L and MouseInArea(lhx,lhy,lhx+255,lhy+255) then
   begin
   MouseHide;
   vybrana:=GetPixel(cil^,mouse.x,mouse.y);
   MouseShow;
   ZobrazZadane;
   MouseRel;
   end;
if Retez^.VyznamAktivniho(akt_bez)=ww_zrus then vybrana:=def;
end;

Procedure TVyberBarvu16Okno.ZobrazMe;
var i,j:longint;
begin
inherited ZobrazMe;
ZobrazZadane;
end;

Destructor TVyberBarvu16Okno.Done;
begin
inherited Done;
end;


end.
