
MMSYSERR_NOERROR	EQU	0
MMSYSERR_BASE		equ 0
MMSYSERR_ERROR			EQU	MMSYSERR_BASE + 1
MMSYSERR_BADDEVICEID	EQU	MMSYSERR_BASE + 2
MMSYSERR_NOTENABLED		EQU	MMSYSERR_BASE + 3
MMSYSERR_ALLOCATED		EQU	MMSYSERR_BASE + 4
MMSYSERR_INVALHANDLE 	EQU MMSYSERR_BASE + 5
MMSYSERR_NODRIVER   	equ MMSYSERR_BASE + 6
MMSYSERR_NOMEM			EQU	MMSYSERR_BASE + 7
MMSYSERR_NOTSUPPORTED	EQU	MMSYSERR_BASE + 8
MMSYSERR_BADERRNUM		EQU	MMSYSERR_BASE + 9
MMSYSERR_INVALFLAG		EQU	MMSYSERR_BASE + 10
MMSYSERR_INVALPARAM 	equ MMSYSERR_BASE + 11

WAVERR_BASE	EQU	32
WAVERR_BADFORMAT	EQU	WAVERR_BASE + 0
WAVERR_STILLPLAYING	EQU	WAVERR_BASE + 1
WAVERR_UNPREPARED	EQU	WAVERR_BASE + 2
WAVERR_SYNC			EQU	WAVERR_BASE + 3
WAVERR_LASTERROR	EQU	WAVERR_BASE + 3

MIDIERR_BASE EQU 64
MIDIERR_UNPREPARED		EQU	MIDIERR_BASE + 0
MIDIERR_STILLPLAYING	EQU	MIDIERR_BASE + 1
MIDIERR_NOMAP			EQU	MIDIERR_BASE + 2
MIDIERR_NOTREADY		EQU	MIDIERR_BASE + 3
MIDIERR_NODEVICE		EQU	MIDIERR_BASE + 4
MIDIERR_INVALIDSETUP	EQU	MIDIERR_BASE + 5
MIDIERR_BADOPENMODE		EQU	MIDIERR_BASE + 6
MIDIERR_DONT_CONTINUE	EQU	MIDIERR_BASE + 7
MIDIERR_LASTERROR		EQU	MIDIERR_BASE + 7

WHDR_DONE		EQU	00000001h
WHDR_PREPARED	EQU	00000002h
WHDR_BEGINLOOP	EQU	00000004h
WHDR_ENDLOOP	EQU	00000008h
WHDR_INQUEUE	EQU	00000010h

TIMERR_NOERROR		EQU	0
TIMERR_BASE			equ 96
TIMERR_NOCANDO		equ TIMERR_BASE + 1
TIMERR_STRUCT		EQU	TIMERR_BASE + 33

WAVE_FORMAT_QUERY			EQU	0001h
WAVE_ALLOWSYNC				EQU	0002h
WAVE_MAPPED					EQU	0004h
WAVE_FORMAT_DIRECT			EQU	0008h
WAVE_FORMAT_DIRECT_QUERY	EQU	( WAVE_FORMAT_QUERY  or  WAVE_FORMAT_DIRECT )

SND_SYNC		EQU	0000h
SND_ASYNC		EQU	0001h
SND_NODEFAULT	EQU	0002h
SND_MEMORY		EQU	0004h
SND_LOOP		EQU	0008h
SND_NOSTOP		EQU	0010h
SND_NOWAIT		EQU	00002000h
SND_ALIAS		EQU	00010000h
SND_ALIAS_ID	EQU	00110000h
SND_FILENAME	EQU	00020000h
SND_RESOURCE	EQU	00040004h

TIME_ONESHOT	EQU	0000h
TIME_PERIODIC	EQU	0001h

TIME_CALLBACK_FUNCTION		EQU	0000h
TIME_CALLBACK_EVENT_SET		EQU	0010h
TIME_CALLBACK_EVENT_PULSE	EQU	0020h

TIMECAPS	struct
wPeriodMin	DWORD	?
wPeriodMax	DWORD	?
TIMECAPS	ends

ifndef LPSTR
LPSTR typedef ptr BYTE
endif

CALLBACK_TYPEMASK	EQU	00070000h
CALLBACK_NULL		EQU	00000000h
CALLBACK_WINDOW		EQU	00010000h
CALLBACK_TASK		EQU	00020000h
CALLBACK_FUNCTION	EQU	00030000h
CALLBACK_THREAD		EQU	CALLBACK_TASK
CALLBACK_EVENT		EQU	00050000h

MM_WOM_OPEN		EQU	3BBh
MM_WOM_CLOSE	EQU	3BCh
MM_WOM_DONE		EQU	3BDh
MM_WIM_OPEN		EQU	3BEh
MM_WIM_CLOSE	EQU	3BFh
MM_WIM_DATA		EQU	3C0h

WOM_OPEN	EQU	<MM_WOM_OPEN>
WOM_CLOSE	EQU	<MM_WOM_CLOSE>
WOM_DONE	EQU	<MM_WOM_DONE>
WIM_OPEN	EQU	<MM_WIM_OPEN>
WIM_CLOSE	EQU	<MM_WIM_CLOSE>
WIM_DATA	EQU	<MM_WIM_DATA>

WAVE_FORMAT_UNKNOWN		EQU	0000h
WAVE_FORMAT_PCM			EQU	0001h
WAVE_FORMAT_ADPCM		EQU	0002h

WAVE_FORMAT_1M08	EQU	00000001h
WAVE_FORMAT_1S08	EQU	00000002h
WAVE_FORMAT_1M16	EQU	00000004h
WAVE_FORMAT_1S16	EQU	00000008h
WAVE_FORMAT_2M08	EQU	00000010h
WAVE_FORMAT_2S08	EQU	00000020h
WAVE_FORMAT_2M16	EQU	00000040h
WAVE_FORMAT_2S16	EQU	00000080h
WAVE_FORMAT_4M08	EQU	00000100h
WAVE_FORMAT_4S08	EQU	00000200h
WAVE_FORMAT_4M16	EQU	00000400h
WAVE_FORMAT_4S16	EQU	00000800h

WAVEFORMATEX	struct
wFormatTag		WORD	?
nChannels		WORD	?
nSamplesPerSec	DWORD	?
nAvgBytesPerSec	DWORD	?
nBlockAlign		WORD	?
wBitsPerSample	WORD	?
cbSize			WORD	?
WAVEFORMATEX	ends

WAVEHDR	struct
lpData			LPSTR	?
dwBufferLength	DWORD	?
dwBytesRecorded	DWORD	?
dwUser			DWORD	?
dwFlags			DWORD	?
dwLoops			DWORD	?
lpNext 			DWORD	?
reserved		DWORD	?
WAVEHDR	ends

LPWAVEHDR typedef ptr WAVEHDR

TIME_MS			EQU	0001h
TIME_SAMPLES	EQU	0002h
TIME_BYTES		EQU	0004h
TIME_SMPTE		EQU	0008h
TIME_MIDI		EQU	0010h
TIME_TICKS		EQU	0020h

MMTIME	struct
wType	DWORD	?
union u
ms		DWORD	?
sample	DWORD	?
cb		DWORD	?
ticks	DWORD	?
struct smpte
hour	BYTE	?
min		BYTE	?
sec		BYTE	?
frame	BYTE	?
fps		BYTE	?
dummy	BYTE	?
pad	BYTE 2 dup (?)
ends
struct midi
songptrpos	DWORD	?
ends
ends
MMTIME	ends

MMVERSION  typedef DWORD
MAXPNAMELEN	EQU	32

WAVEOUTCAPSA	struct
wMid			WORD	?
wPid			WORD	?
vDriverVersion	MMVERSION	?
szPname			SBYTE MAXPNAMELEN dup (?)
dwFormats		DWORD	?
wChannels		WORD	?
wReserved1		WORD	?
dwSupport		DWORD	?
WAVEOUTCAPSA	ends

WAVE_MAPPER	EQU	- 1

;--- midi

MIDI_MAPPER	EQU	- 1

MIDIHDR	struct
lpData		LPSTR	?
dwBufferLength	DWORD	?
dwBytesRecorded	DWORD	?
dwUser		DWORD	?
dwFlags		DWORD	?
lpNext 		DWORD ?
reserved	DWORD	?
dwOffset	DWORD	?
dwReserved	DWORD 8 dup (?)
MIDIHDR	ends

LPMIDIHDR typedef ptr MIDIHDR

MIDIEVENT	struct
dwDeltaTime	DWORD	?
dwStreamID	DWORD	?
dwEvent		DWORD	?
dwParms		DWORD 1 dup (?)
MIDIEVENT	ends

MIDISTRMBUFFVER	struct
dwVersion		DWORD	?
dwMid			DWORD	?
dwOEMVersion	DWORD	?
MIDISTRMBUFFVER	ends

MHDR_DONE		EQU	00000001h
MHDR_PREPARED	EQU	00000002h
MHDR_INQUEUE	EQU	00000004h
MHDR_ISSTRM		EQU	00000008h

MEVT_F_SHORT	EQU	00000000h
MEVT_F_LONG		EQU	80000000h
MEVT_F_CALLBACK	EQU	40000000h

MEVT_EVENTTYPE macro x
	exitm <( ( ( x  shr  24 ) & 0FFh ) ) >
	endm
MEVT_EVENTPARM macro x
	exitm <( ( x & 0FFFFFFh ) ) >
	endm

MEVT_SHORTMSG	EQU	00h
MEVT_TEMPO		EQU	01h
MEVT_NOP		EQU	02h
MEVT_LONGMSG	EQU	80h
MEVT_COMMENT	EQU	82h
MEVT_VERSION	EQU	84h

MIDIOUTCAPSA	struct
wMid			WORD	?
wPid			WORD	?
vDriverVersion	MMVERSION	?
szPname			SBYTE MAXPNAMELEN dup (?)
wTechnology		WORD	?
wVoices			WORD	?
wNotes			WORD	?
wChannelMask	WORD	?
dwSupport		DWORD	?
MIDIOUTCAPSA	ends

LPMIDIOUTCAPSA typedef ptr MIDIOUTCAPSA

MOD_MIDIPORT	EQU	1
MOD_SYNTH		EQU	2
MOD_SQSYNTH		EQU	3
MOD_FMSYNTH		EQU	4
MOD_MAPPER		EQU	5

MIDICAPS_VOLUME		EQU	0001h
MIDICAPS_LRVOLUME	EQU	0002h
MIDICAPS_CACHE		EQU	0004h
MIDICAPS_STREAM		EQU	0008h

MM_MOM_OPEN		EQU	3C7h
MM_MOM_CLOSE	EQU	3C8h
MM_MOM_DONE		EQU	3C9h

MOM_OPEN	EQU	<MM_MOM_OPEN>
MOM_CLOSE	EQU	<MM_MOM_CLOSE>
MOM_DONE	EQU	<MM_MOM_DONE>

MCIERR_BASE	EQU	256

MCIERR_INVALID_DEVICE_ID	EQU	( MCIERR_BASE + 1 )
MCIERR_UNRECOGNIZED_KEYWORD	EQU	( MCIERR_BASE + 3 )
MCIERR_UNRECOGNIZED_COMMAND	EQU	( MCIERR_BASE + 5 )
MCIERR_HARDWARE				EQU	( MCIERR_BASE + 6 )
MCIERR_INVALID_DEVICE_NAME	EQU	( MCIERR_BASE + 7 )
MCIERR_OUT_OF_MEMORY		EQU	( MCIERR_BASE + 8 )
MCIERR_DEVICE_OPEN			EQU	( MCIERR_BASE + 9 )
MCIERR_CANNOT_LOAD_DRIVER	EQU	( MCIERR_BASE + 10 )
MCIERR_MISSING_COMMAND_STRING	EQU	( MCIERR_BASE + 11 )
MCIERR_PARAM_OVERFLOW		EQU	( MCIERR_BASE + 12 )
MCIERR_MISSING_STRING_ARGUMENT	EQU	( MCIERR_BASE + 13 )
MCIERR_BAD_INTEGER			EQU	( MCIERR_BASE + 14 )
MCIERR_PARSER_INTERNAL		EQU	( MCIERR_BASE + 15 )
MCIERR_DRIVER_INTERNAL		EQU	( MCIERR_BASE + 16 )
MCIERR_MISSING_PARAMETER	EQU	( MCIERR_BASE + 17 )
MCIERR_UNSUPPORTED_FUNCTION	EQU	( MCIERR_BASE + 18 )
MCIERR_FILE_NOT_FOUND		EQU	( MCIERR_BASE + 19 )
MCIERR_DEVICE_NOT_READY		EQU	( MCIERR_BASE + 20 )

;-----------

ifdef _WINMM_
?INDCALL_ = 0
elseif ?INDCALL eq 0
?INDCALL_ = 0
else
?INDCALL_ = 1
endif

if ?INDCALL_ eq 0

midiStreamOpen     proto :ptr DWORD, :ptr DWORD, :DWORD, :DWORD, :DWORD, :DWORD
midiStreamClose    proto :DWORD
midiStreamOut      proto :DWORD, :LPMIDIHDR, :DWORD
midiStreamPause    proto :DWORD
midiStreamRestart  proto :DWORD
midiStreamStop     proto :DWORD

midiOutReset       proto :DWORD

timeKillEvent      proto :DWORD
timeSetEvent       proto :DWORD, :DWORD, :DWORD, :DWORD, :DWORD

waveOutClose       proto :dword
waveOutGetDevCapsA proto :DWORD, :ptr WAVEOUTCAPSA, :DWORD
waveOutGetNumDevs  proto
waveOutGetPosition proto :dword, :ptr MMTIME, :dword
waveOutOpen        proto :ptr DWORD, :DWORD, :ptr WAVEFORMATEX, :DWORD, :DWORD, :DWORD
waveOutPrepareHeader proto :dword, :ptr WAVEHDR, :dword
waveOutPause       proto :dword
waveOutReset       proto :dword
waveOutRestart     proto :dword
waveOutUnprepareHeader proto :dword, :ptr WAVEHDR, :dword
waveOutWrite       proto :dword, :ptr WAVEHDR, :dword

else

;	.DATA
_DATA segment

externdef stdcall _imp__waveOutClose@4:pfunc@4
externdef stdcall _imp__waveOutGetDevCapsA@12:pfunc@12
externdef stdcall _imp__waveOutGetNumDevs@0:pfunc@0
externdef stdcall _imp__waveOutGetPosition@12:pfunc@12
externdef stdcall _imp__waveOutOpen@24:pfunc@24
externdef stdcall _imp__waveOutPrepareHeader@12:pfunc@12
externdef stdcall _imp__waveOutPause@4:pfunc@4
externdef stdcall _imp__waveOutReset@4:pfunc@4
externdef stdcall _imp__waveOutRestart@4:pfunc@4
externdef stdcall _imp__waveOutUnprepareHeader@12:pfunc@12
externdef stdcall _imp__waveOutWrite@12:pfunc@12

_DATA ends

waveOutClose         equ <_imp__waveOutClose@4>
waveOutGetDevCapsA   equ <_imp__waveOutGetDevCapsA@12>
waveOutGetNumDevs    equ <_imp__waveOutGetNumDevs@0>
waveOutGetPosition   equ <_imp__waveOutGetPosition@12>
waveOutOpen          equ <_imp__waveOutOpen@24>
waveOutPrepareHeader equ <_imp__waveOutPrepareHeader@12>
waveOutPause         equ <_imp__waveOutPause@4>
waveOutReset         equ <_imp__waveOutReset@4>
waveOutRestart       equ <_imp__waveOutRestart@4>
waveOutUnprepareHeader equ <_imp__waveOutUnprepareHeader@12>
waveOutWrite         equ <_imp__waveOutWrite@12>

endif
