#ifdef __UNIX_SYSTEM__
    
    ' источники (где брал основу для кода): 
    ' https://stackoverflow.com/questions/27378318/c-get-string-from-clipboard-on-linux
    ' https://github.com/exebook/x11clipboard
    ' только приспособил под свои задачи
    
    dim shared as Display ptr pXDisplay
    
    dim shared as Window pxWindow
    
    function OpenClipBoard() as Long
        
        pXDisplay = XOpenDisplay(0)
        
        if pXDisplay then
            
            dim as UINTEGER iColor = BlackPixel(pXDisplay, DefaultScreen(pXDisplay))
            
            pXWindow = XCreateSimpleWindow(pXDisplay, DefaultRootWindow(pXDisplay),0,0,1,1,0,iColor,iColor)
            
            return 1
            
        EndIf
        
    End function
    
    sub CloseClipBoard()
        
        if pXDisplay then
            
            XDestroyWindow(pXDisplay, pXWindow)
            
            XCloseDisplay(pXDisplay)
            
        EndIf
        
    End Sub
    
    sub SetTextClipBoard(pszText as zstring ptr)
        
        if pObj.iParametersClipBoard then
            
            dim as XEvent event	
            dim as Long iFlag	
            dim as Long iLen = len(*pszText)
            
            OpenClipBoard()
            
            dim as XAtom xAtomCB = XInternAtom(pXDisplay, "CLIPBOARD", 0)	
            dim as XAtom xAtomFT_Text = XInternAtom(pXDisplay, "TEXT", 0)	
            dim as XAtom targets_atom = XInternAtom(pXDisplay, "TARGETS", 0)	
            dim as XAtom xAtomFT_UTF8 = XInternAtom(pXDisplay, "UTF8_STRING", 1)
            dim as XAtom XA_ATOM = 4, XA_STRING = 31
            
            if (xAtomFT_UTF8 = 0) then xAtomFT_UTF8 = XA_STRING
            
            XSetSelectionOwner (pXDisplay, xAtomCB, pxWindow, 0)
            
            if (XGetSelectionOwner (pXDisplay, xAtomCB) <> pxWindow) then 
                
                CloseClipBoard()
                
                exit sub
                
            EndIf
            
            while (1) 
                
                XNextEvent (pXDisplay, @event)
                
                select case event.type
                        
                    case SelectionRequest
                        
                        if event.xselectionrequest.selection <> xAtomCB then continue while
                        
                        dim as XSelectionRequestEvent ptr xsr = @event.xselectionrequest
                        
                        dim as XSelectionEvent ev
                        dim as Long R
                        
                        ev.type = SelectionNotify
                        ev.display = xsr->display
                        ev.requestor = xsr->requestor
                        ev.selection = xsr->selection
                        ev.time = xsr->time
                        ev.target = xsr->target
                        ev.property = xsr->property
                        
                        if (ev.target = targets_atom)  then 
                            
                            R = XChangeProperty (ev.display, ev.requestor, ev.property, XA_ATOM, 32,_
                            PropModeReplace, cast(any ptr ,@xAtomFT_UTF8), 1)
                            
                        elseif (ev.target = XA_STRING orelse ev.target = xAtomFT_Text) then
                            
                            R = XChangeProperty(ev.display, ev.requestor, ev.property, XA_STRING, 8, PropModeReplace, pszText, iLen)
                            
                            iFlag = 1
                            
                        elseif (ev.target = xAtomFT_UTF8) then
                            
                            R = XChangeProperty(ev.display, ev.requestor, ev.property, xAtomFT_UTF8, 8, PropModeReplace, pszText, iLen)
                            
                            iFlag = 1
                            
                        else 
                            
                            ev.property = 0
                            
                        EndIf
                        
                        if ((R and 2) = 0) then 
                            
                            XSendEvent (pXDisplay, ev.requestor, 0, 0, cast (any ptr ,@ev))
                            
                            if iFlag = 1 then
                                
                                exit while
                                
                            EndIf
                            
                        EndIf
                        
                    case SelectionClear
                        
                        exit while
                        
                end select
                
            wend
            
            CloseClipBoard()
            
        else
            
            if pObj.pszClipBuffer then deallocate(pObj.pszClipBuffer)
            
            pObj.pszClipBuffer = callocate(len(*pszText)+1)
            
            if pObj.pszClipBuffer then
            
				*(pObj.pszClipBuffer) = *pszText
				
			else
			
				DrawErrorMemory() ' выводим ошибку памяти
            
            endif
            
        endif
        
    End Sub
    
    private function GetTextFromClipBoardType(pszFmtName as zstring ptr) as zstring ptr
        
        dim as zstring ptr pszResult , pszRetString
        
        dim as UINTeger iResize
        
        dim as UINTeger iResTail
        
        dim as long iResBits
        
        ' создаем атомы для строк
        dim as xAtom xAtomCB = XInternAtom(pXDisplay, "CLIPBOARD", 0)
        dim as xAtom xAtomFT = XInternAtom(pXDisplay, pszFmtName, 0)
        dim as xAtom xAtomID = XInternAtom(pXDisplay, "XSEL_DATA", 0)
        dim as xAtom xAtomINCR = XInternAtom(pXDisplay, "INCR", 0)
        
        dim as XEvent event
        
        XSelectInput (pXDisplay, pxWindow, PropertyChangeMask)
        
        XConvertSelection(pXDisplay, xAtomCB, xAtomFT, xAtomID, pxWindow, CurrentTime)
        
        do 
            
            XNextEvent(pXDisplay, @event) 
            
        loop while (event.type <> SelectionNotify orelse event.xselection.selection <> xAtomCB)
        
        if (event.xselection.property) then
            
            XGetWindowProperty(pXDisplay, pxWindow, xAtomID, 0, 2147483647L/4, 1, AnyPropertyType,_
            @xAtomFT, @iResBits, @iResize, @iResTail, @pszResult)
            
            if (xAtomFT <> xAtomINCR) then
                
                if pszResult then pszRetString = callocate(len(*pszResult)+1)
                
                if pszRetString then
                
					*pszRetString = *pszResult
					
				elseif pszResult then
				
					DrawErrorMemory() ' выводим ошибку памяти
                
                endif
                
            endif
            
            XFree(pszResult)
            
            if (xAtomFT = xAtomINCR) then
                
                do 
                    
                    do 
                        
                        XNextEvent(pXDisplay, @event)
                        
                    loop while (event.type <> PropertyNotify orelse event.xproperty.atom <> xAtomID orelse event.xproperty.state <> PropertyNewValue)
                    
                    XGetWindowProperty(pXDisplay, pxWindow, xAtomID, 0, 2147483647L/4, 1, AnyPropertyType,_
                    @xAtomFT, @iResBits, @iResize, @iResTail, @pszResult)
                    
                    if pszResult then pszRetString = callocate(len(*pszResult)+1)
                    
                    if pszRetString then
                    
						*pszRetString = *pszResult
						
					elseif pszResult then
					
						DrawErrorMemory() ' выводим ошибку памяти
                    
                    endif
                    
                    XFree(pszResult)
                    
                loop while (iResize > 0)
                
            endif
            
            return pszRetString
            
        else
            
            return 0
            
        endif
        
    end function
    
    function GetTextClipBoard() as zstring ptr
        
        if pObj.iParametersClipBoard then
            
            OpenClipBoard()
            
            dim as zstring ptr pszResult = GetTextFromClipBoardType("UTF8_STRING")
            
            if pszResult = 0 then
                
                pszResult = GetTextFromClipBoardType("STRING")
                
            EndIf
            
            CloseClipBoard()
            
            return pszResult
            
        else
            
            if pObj.pszClipBuffer then
                
                return pObj.pszClipBuffer
                
            EndIf
            
        endif
        
    End Function
    
#endif

#ifdef __FB_WIN32__
    'основа для кода взята из моей библиотеки window9: https://sourceforge.net/projects/guiwindow9/
    function OpenClipBoard() as Long
        return w32OpenClipboard(0)
    End function
    
    sub CloseClipBoard()
        w32CloseClipboard()
    End Sub
    
    sub SetTextClipBoard(pszText as zstring ptr)
		
		if pszText = 0 andalso len(*pszText) = 0 then exit sub
		
		dim as wstring ptr pwsBuf = Utf8tounicode(*pszText)
		
		if pwsBuf then
		
			dim as any ptr hClip = w32GlobalAlloc(w32GMEM_MOVEABLE Or w32GMEM_SHARE, Len(*pwsBuf)*2+2)
			
			if hClip then
			
				OpenClipboard()
				
				w32EmptyClipboard()
				
				dim as any ptr hMem = w32GlobalLock(hClip)
				
				memcpy(hMem, pwsBuf, Len(*pwsBuf)*2)
				
				w32GlobalUnlock(hMem)
				
				w32SetClipboardData(w32CF_UNICODETEXT,hClip)
				
				CloseClipboard()
			
			endif
			
			deallocate(pwsBuf)
		
		endif
		
    End Sub
    
    function GetTextClipBoard() as zstring ptr
        
        if pObj.iParametersClipBoard then
            
            OpenClipBoard()
            
            dim as any ptr hClip = w32GetClipboardData(w32CF_UNICODETEXT)
            
            if hClip then
            
				dim as Long iSize = w32GlobalSize(hClip)
				
				Dim pwsBuf As WSTRING ptr = Callocate((iSize+2)*sizeof(wstring))
				
				if pwsBuf then
				
					dim as any ptr hMem = w32GlobalLock(hClip)
					
					memcpy(pwsBuf, hMem, iSize)
					
					dim as zstring ptr pszResult = callocate((len(*pwsBuf)+1)*6)
					
					if pszResult then
					
						*pszResult = Unicodetoutf8(pwsBuf)
						
					else
					
						DrawErrorMemory() ' выводим ошибку памяти
					
					endif
		 
					w32GlobalUnlock(hMem)
					
					CloseClipBoard()
					
					deallocate pwsBuf
					
					return pszResult
					
				else
				
					DrawErrorMemory() ' выводим ошибку памяти
				
				endif
            
            endif
            
        else
            
            if pObj.pszClipBuffer then
                
                return pObj.pszClipBuffer
                
            EndIf
            
        endif
        
    End Function
#EndIf

#ifdef __FB_DOS__

	sub SetTextClipBoard(pszText as zstring ptr)
		
		if pObj.pszClipBuffer then deallocate(pObj.pszClipBuffer)
		
		pObj.pszClipBuffer = callocate(len(*pszText)+1)
		
		if pObj.pszClipBuffer then
		
			*(pObj.pszClipBuffer) = *pszText
			
		else
		
			DrawErrorMemory() ' выводим ошибку памяти
		
		endif
		
	End Sub
	
	function GetTextClipBoard() as zstring ptr
		
		if pObj.pszClipBuffer then
			
			return pObj.pszClipBuffer
			
		EndIf
		
	End Function

#EndIf