#INCLUDE ONCE "dos/dpmi.bi"
#INCLUDE ONCE "dos/sys/movedata.bi"
#INCLUDE ONCE "dos/sys/segments.bi"

Type COUNTRYINFO
  ciDateFormat      As Ushort
  ciCurrency        As Zstring * 5
  ciThousands       As Zstring * 2
  ciDecimal         As Zstring * 2
  ciDateSep         As Zstring * 2
  ciTimeSep         As Zstring * 2
  ciBitField        As Ubyte
  ciCurrencyPlaces  As Ubyte
  ciTimeFormat      As Ubyte
  ciCaseMap         As Integer
  ciDataSep         As Zstring * 2
  ciReserved        (1 To 10) As Ubyte
End Type

Function GetCountryInfo( Byval pci As COUNTRYINFO Ptr ) As Integer

    Dim As Integer n = sizeof(COUNTRYINFO)
    Dim As Ushort npara = n \ 16 + 1
    Dim As Short rmseg, pmsel, failed
    Dim As __dpmi_regs regs

    '' Allocate a buffer that DOS can address.
    ''
    asm
      mov bx, [npara]
      mov ax, 0x100
      Int 0x31
      mov [rmseg], ax
      mov [pmsel], dx
      sbb ax, ax
      mov [failed], ax
    End asm
    If failed Then Return failed

    '' Call the DOS Get/Set Country Information function.
    ''
    regs.x.ax = &h3800
    regs.x.ds = rmseg
    If (__dpmi_int(&h21, @regs)) Then Return -1

    '' If CF set, return error code.
    ''
    If regs.x.flags And 1 Then Return regs.x.ax

    movedata( pmsel, 0, _my_ds(), cast(Uinteger,pci), n )

    __dpmi_free_dos_memory( pmsel )

    Return 0

End Function

'DIM AS COUNTRYINFO ci

'Print GetCountryInfo(@ci)
'Print
'print "ciDateFormat     ";ci.ciDateFormat
'Print "ciCurrency       ";ci.ciCurrency
'Print "ciThousands      ";ci.ciThousands
'Print "ciDecimal        ";ci.ciDecimal
'Print "ciDateSep        ";ci.ciDateSep
'Print "ciTimeSep        ";ci.ciTimeSep
'Print "ciBitField       ";ci.ciBitField
'Print "ciCurrencyPlaces ";ci.ciCurrencyPlaces
'Print "ciTimeFormat     ";ci.ciTimeFormat
'Print "ciCaseMap        ";hex(ci.ciCaseMap)
'Print "ciDataSep        ";ci.ciDataSep
